/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.business;

import it.auties.whatsapp.model.business.BusinessCategory;
import it.auties.whatsapp.model.business.BusinessHours;
import it.auties.whatsapp.model.business.BusinessHoursEntry;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.node.Node;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public record BusinessProfile(Jid jid, Optional<String> description, Optional<String> address, Optional<String> email, Optional<BusinessHours> hours, boolean cartEnabled, List<URI> websites, List<BusinessCategory> categories) {
    public static BusinessProfile of(Node node) {
        Jid jid = node.attributes().getRequiredJid("jid");
        Optional<String> address = node.findChild("address").flatMap(Node::contentAsString);
        Optional<String> description = node.findChild("description").flatMap(Node::contentAsString);
        List<URI> websites = node.listChildren("website").stream().map(Node::contentAsString).flatMap(Optional::stream).map(URI::create).toList();
        Optional<String> email = node.findChild("email").flatMap(Node::contentAsString);
        List<BusinessCategory> categories = node.listChildren("categories").stream().map(entry -> entry.findChild("category")).flatMap(Optional::stream).map(BusinessCategory::of).toList();
        Optional<Node> commerceExperience = node.findChild("profile_options");
        Boolean cartEnabled = commerceExperience.flatMap(entry -> entry.findChild("cart_enabled")).flatMap(Node::contentAsBoolean).orElse(commerceExperience.isEmpty());
        Optional<BusinessHours> hours = BusinessProfile.createHours(node);
        return new BusinessProfile(jid, description, address, email, hours, cartEnabled, websites, categories);
    }

    private static Optional<BusinessHours> createHours(Node node) {
        Optional<String> timezone = node.findChild("business_hours").map(Node::attributes).map(attributes -> attributes.getNullableString("timezone"));
        if (timezone.isEmpty()) {
            return Optional.empty();
        }
        List<BusinessHoursEntry> entries = node.findChild("business_hours").stream().map(entry -> entry.listChildren("business_hours_config")).flatMap(Collection::stream).map(BusinessHoursEntry::of).toList();
        return Optional.of(new BusinessHours(timezone.get(), entries));
    }
}

