/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.call;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.model.ProtobufString;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.call.Call;
import it.auties.whatsapp.model.call.CallStatus;
import it.auties.whatsapp.model.call.CallStatusSpec;
import it.auties.whatsapp.model.jid.Jid;

public class CallSpec {
    public static byte[] encode(Call protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)CallSpec.sizeOf(protoInputObject));
        CallSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(Call protoInputObject, ProtobufOutputStream protoOutputStream) {
        ProtobufString id0;
        String id;
        ProtobufString caller1;
        String caller0;
        Jid caller;
        ProtobufString chat1;
        String chat0;
        if (protoInputObject == null) {
            return;
        }
        Jid chat = protoInputObject.chat();
        if (chat != null && (chat0 = chat.toString()) != null && (chat1 = ProtobufLazyMixin.toValue((String)chat0)) != null) {
            protoOutputStream.writeString(1, chat1);
        }
        if ((caller = protoInputObject.caller()) != null && (caller0 = caller.toString()) != null && (caller1 = ProtobufLazyMixin.toValue((String)caller0)) != null) {
            protoOutputStream.writeString(2, caller1);
        }
        if ((id = protoInputObject.id()) != null && (id0 = ProtobufLazyMixin.toValue((String)id)) != null) {
            protoOutputStream.writeString(3, id0);
        }
        long timestampSeconds = protoInputObject.timestampSeconds();
        protoOutputStream.writeUInt64(4, Long.valueOf(timestampSeconds));
        boolean video = protoInputObject.video();
        protoOutputStream.writeBool(5, Boolean.valueOf(video));
        CallStatus status = protoInputObject.status();
        if (status != null) {
            Integer status0 = CallStatusSpec.encode(status);
            protoOutputStream.writeInt32(6, status0);
        }
        boolean offline = protoInputObject.offline();
        protoOutputStream.writeBool(7, Boolean.valueOf(offline));
    }

    public static Call decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return CallSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static Call decode(ProtobufInputStream protoInputStream) {
        Jid chat = null;
        Jid caller = null;
        String id = null;
        long timestampSeconds = 0L;
        boolean video = false;
        CallStatus status = null;
        boolean offline = false;
        block9: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    chat = Jid.of(ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString()));
                    continue block9;
                }
                case 2: {
                    caller = Jid.of(ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString()));
                    continue block9;
                }
                case 3: {
                    id = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block9;
                }
                case 4: {
                    timestampSeconds = protoInputStream.readInt64();
                    continue block9;
                }
                case 5: {
                    video = protoInputStream.readBool();
                    continue block9;
                }
                case 6: {
                    status = CallStatusSpec.decode(protoInputStream.readInt32());
                    continue block9;
                }
                case 7: {
                    offline = protoInputStream.readBool();
                    continue block9;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new Call(chat, caller, id, timestampSeconds, video, status, offline);
    }

    public static int sizeOf(Call protoInputObject) {
        ProtobufString id0;
        String id;
        ProtobufString caller1;
        String caller0;
        Jid caller;
        ProtobufString chat1;
        String chat0;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        Jid chat = protoInputObject.chat();
        if (chat != null && (chat0 = chat.toString()) != null && (chat1 = ProtobufLazyMixin.toValue((String)chat0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)chat1);
        }
        if ((caller = protoInputObject.caller()) != null && (caller0 = caller.toString()) != null && (caller1 = ProtobufLazyMixin.toValue((String)caller0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)caller1);
        }
        if ((id = protoInputObject.id()) != null && (id0 = ProtobufLazyMixin.toValue((String)id)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)id0);
        }
        long timestampSeconds = protoInputObject.timestampSeconds();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)timestampSeconds);
        boolean video = protoInputObject.video();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)5, (int)0);
        ++protoOutputSize;
        CallStatus status = protoInputObject.status();
        if (status != null) {
            Integer status0 = CallStatusSpec.encode(status);
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)6, (int)2);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)status0.intValue());
        }
        boolean offline = protoInputObject.offline();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)7, (int)0);
        return ++protoOutputSize;
    }
}

