/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.chat;

import com.fasterxml.jackson.annotation.JsonCreator;
import it.auties.protobuf.annotation.ProtobufEnum;
import it.auties.protobuf.annotation.ProtobufMessage;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.chat.ChatDisappear;
import it.auties.whatsapp.model.chat.ChatEphemeralTimer;
import it.auties.whatsapp.model.chat.ChatMute;
import it.auties.whatsapp.model.chat.ChatWallpaper;
import it.auties.whatsapp.model.contact.ContactStatus;
import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.jid.JidProvider;
import it.auties.whatsapp.model.jid.JidType;
import it.auties.whatsapp.model.media.MediaVisibility;
import it.auties.whatsapp.model.message.model.MessageCategory;
import it.auties.whatsapp.model.sync.HistorySyncMessage;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.ConcurrentLinkedSet;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

@ProtobufMessage(name="Conversation")
public final class Chat
implements JidProvider {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    final Jid jid;
    @ProtobufProperty(index=2, type=ProtobufType.MESSAGE)
    final ConcurrentLinkedSet<HistorySyncMessage> historySyncMessages;
    @ProtobufProperty(index=3, type=ProtobufType.STRING)
    final Jid newJid;
    @ProtobufProperty(index=4, type=ProtobufType.STRING)
    final Jid oldJid;
    @ProtobufProperty(index=6, type=ProtobufType.UINT32)
    int unreadMessagesCount;
    @ProtobufProperty(index=8, type=ProtobufType.BOOL)
    boolean endOfHistoryTransfer;
    @ProtobufProperty(index=9, type=ProtobufType.UINT32)
    ChatEphemeralTimer ephemeralMessageDuration;
    @ProtobufProperty(index=10, type=ProtobufType.INT64)
    long ephemeralMessagesToggleTimeSeconds;
    @ProtobufProperty(index=11, type=ProtobufType.ENUM)
    EndOfHistoryTransferType endOfHistoryTransferType;
    @ProtobufProperty(index=12, type=ProtobufType.UINT64)
    long timestampSeconds;
    @ProtobufProperty(index=13, type=ProtobufType.STRING)
    String name;
    @ProtobufProperty(index=15, type=ProtobufType.BOOL)
    boolean notSpam;
    @ProtobufProperty(index=16, type=ProtobufType.BOOL)
    boolean archived;
    @ProtobufProperty(index=17, type=ProtobufType.MESSAGE)
    ChatDisappear disappearInitiator;
    @ProtobufProperty(index=19, type=ProtobufType.BOOL)
    boolean markedAsUnread;
    @ProtobufProperty(index=24, type=ProtobufType.UINT32)
    int pinnedTimestampSeconds;
    @ProtobufProperty(index=25, type=ProtobufType.UINT64)
    ChatMute mute;
    @ProtobufProperty(index=26, type=ProtobufType.MESSAGE)
    ChatWallpaper wallpaper;
    @ProtobufProperty(index=27, type=ProtobufType.ENUM)
    MediaVisibility mediaVisibility;
    @ProtobufProperty(index=29, type=ProtobufType.BOOL)
    boolean suspended;
    @ProtobufProperty(index=30, type=ProtobufType.BOOL)
    boolean terminated;
    @ProtobufProperty(index=34, type=ProtobufType.BOOL)
    boolean support;
    @ProtobufProperty(index=38, type=ProtobufType.STRING)
    String displayName;
    @ProtobufProperty(index=39, type=ProtobufType.STRING)
    Jid phoneJid;
    @ProtobufProperty(index=40, type=ProtobufType.BOOL)
    boolean shareOwnPhoneNumber;
    @ProtobufProperty(index=41, type=ProtobufType.BOOL)
    boolean pnhDuplicateLidThread;
    @ProtobufProperty(index=42, type=ProtobufType.STRING)
    Jid lid;
    @ProtobufProperty(index=999, type=ProtobufType.MAP, mapKeyType=ProtobufType.STRING, mapValueType=ProtobufType.ENUM)
    final ConcurrentHashMap<Jid, ContactStatus> presences;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    Chat(Jid jid, ConcurrentLinkedSet<HistorySyncMessage> historySyncMessages, Jid newJid, Jid oldJid, int unreadMessagesCount, boolean endOfHistoryTransfer, ChatEphemeralTimer ephemeralMessageDuration, long ephemeralMessagesToggleTimeSeconds, EndOfHistoryTransferType endOfHistoryTransferType, long timestampSeconds, String name, boolean notSpam, boolean archived, ChatDisappear disappearInitiator, boolean markedAsUnread, int pinnedTimestampSeconds, ChatMute mute, ChatWallpaper wallpaper, MediaVisibility mediaVisibility, boolean suspended, boolean terminated, boolean support, String displayName, Jid phoneJid, boolean shareOwnPhoneNumber, boolean pnhDuplicateLidThread, Jid lid, ConcurrentHashMap<Jid, ContactStatus> presences) {
        this.jid = jid;
        this.historySyncMessages = historySyncMessages;
        this.newJid = newJid;
        this.oldJid = oldJid;
        this.unreadMessagesCount = unreadMessagesCount;
        this.endOfHistoryTransfer = endOfHistoryTransfer;
        this.ephemeralMessageDuration = ephemeralMessageDuration;
        this.ephemeralMessagesToggleTimeSeconds = ephemeralMessagesToggleTimeSeconds;
        this.endOfHistoryTransferType = endOfHistoryTransferType;
        this.timestampSeconds = timestampSeconds;
        this.name = name;
        this.notSpam = notSpam;
        this.archived = archived;
        this.disappearInitiator = disappearInitiator;
        this.markedAsUnread = markedAsUnread;
        this.pinnedTimestampSeconds = pinnedTimestampSeconds;
        this.mute = mute;
        this.wallpaper = wallpaper;
        this.mediaVisibility = mediaVisibility;
        this.suspended = suspended;
        this.terminated = terminated;
        this.support = support;
        this.displayName = displayName;
        this.phoneJid = phoneJid;
        this.shareOwnPhoneNumber = shareOwnPhoneNumber;
        this.pnhDuplicateLidThread = pnhDuplicateLidThread;
        this.lid = lid;
        this.presences = presences;
    }

    public String name() {
        if (this.name != null) {
            return this.name;
        }
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.jid.user();
    }

    public boolean isGroup() {
        return this.jid.type() == JidType.GROUP;
    }

    public boolean isPinned() {
        return this.pinnedTimestampSeconds != 0;
    }

    public boolean isEphemeral() {
        return this.ephemeralMessageDuration != ChatEphemeralTimer.OFF && this.ephemeralMessagesToggleTimeSeconds != 0L;
    }

    public Collection<ChatMessageInfo> unreadMessages() {
        if (!this.hasUnreadMessages()) {
            return List.of();
        }
        return this.historySyncMessages.stream().limit(this.unreadMessagesCount()).map(HistorySyncMessage::messageInfo).toList();
    }

    public boolean hasUnreadMessages() {
        return this.unreadMessagesCount > 0;
    }

    public Optional<ZonedDateTime> pinnedTimestamp() {
        return Clock.parseSeconds(this.pinnedTimestampSeconds);
    }

    public Optional<ZonedDateTime> timestamp() {
        return Clock.parseSeconds(this.timestampSeconds);
    }

    public Optional<ZonedDateTime> ephemeralMessagesToggleTime() {
        return Clock.parseSeconds(this.ephemeralMessagesToggleTimeSeconds);
    }

    public Optional<ChatMessageInfo> newestMessage() {
        return Optional.ofNullable(this.historySyncMessages.peekLast()).map(HistorySyncMessage::messageInfo);
    }

    public Optional<ChatMessageInfo> oldestMessage() {
        return Optional.ofNullable(this.historySyncMessages.peekFirst()).map(HistorySyncMessage::messageInfo);
    }

    public Optional<ChatMessageInfo> newestStandardMessage() {
        return this.findMessageBy(this::isStandardMessage, true);
    }

    public Optional<ChatMessageInfo> oldestStandardMessage() {
        return this.findMessageBy(this::isStandardMessage, false);
    }

    private boolean isStandardMessage(ChatMessageInfo info) {
        return !info.message().hasCategory(MessageCategory.SERVER) && info.stubType().isEmpty();
    }

    public Optional<ChatMessageInfo> newestMessageFromMe() {
        return this.findMessageBy(this::isMessageFromMe, true);
    }

    public Optional<ChatMessageInfo> oldestMessageFromMe() {
        return this.findMessageBy(this::isMessageFromMe, false);
    }

    private boolean isMessageFromMe(ChatMessageInfo info) {
        return !info.message().hasCategory(MessageCategory.SERVER) && info.stubType().isEmpty() && info.fromMe();
    }

    public Optional<ChatMessageInfo> newestServerMessage() {
        return this.findMessageBy(this::isServerMessage, true);
    }

    public Optional<ChatMessageInfo> oldestServerMessage() {
        return this.findMessageBy(this::isServerMessage, false);
    }

    private boolean isServerMessage(ChatMessageInfo info) {
        return info.message().hasCategory(MessageCategory.SERVER) || info.stubType().isPresent();
    }

    private Optional<ChatMessageInfo> findMessageBy(Function<ChatMessageInfo, Boolean> filter, boolean newest) {
        Iterator<HistorySyncMessage> descendingIterator;
        Iterator<HistorySyncMessage> iterator = descendingIterator = newest ? this.historySyncMessages.descendingIterator() : this.historySyncMessages.iterator();
        while (descendingIterator.hasNext()) {
            ChatMessageInfo info = descendingIterator.next().messageInfo();
            if (!filter.apply(info).booleanValue()) continue;
            return Optional.of(info);
        }
        return Optional.empty();
    }

    public Collection<ChatMessageInfo> starredMessages() {
        return this.historySyncMessages.stream().map(HistorySyncMessage::messageInfo).filter(ChatMessageInfo::starred).toList();
    }

    public void addMessages(Collection<HistorySyncMessage> newMessages) {
        this.historySyncMessages.addAll(newMessages);
    }

    public void addOldMessages(Collection<HistorySyncMessage> oldMessages) {
        oldMessages.forEach(this.historySyncMessages::addFirst);
    }

    public boolean addNewMessage(ChatMessageInfo info) {
        HistorySyncMessage sync = new HistorySyncMessage(info, this.historySyncMessages.size());
        if (this.historySyncMessages.contains(sync)) {
            return false;
        }
        this.historySyncMessages.add(sync);
        this.updateChatTimestamp(info);
        return true;
    }

    public boolean addOldMessage(HistorySyncMessage info) {
        this.historySyncMessages.addFirst(info);
        return true;
    }

    public boolean removeMessage(ChatMessageInfo info) {
        boolean result = this.historySyncMessages.removeIf(entry -> Objects.equals(entry.messageInfo().id(), info.id()));
        this.refreshChatTimestamp();
        return result;
    }

    public boolean removeMessage(Predicate<? super ChatMessageInfo> predicate) {
        boolean result = this.historySyncMessages.removeIf(entry -> predicate.test(entry.messageInfo()));
        this.refreshChatTimestamp();
        return result;
    }

    private void refreshChatTimestamp() {
        Optional<ChatMessageInfo> message = this.newestMessage();
        if (message.isEmpty()) {
            return;
        }
        this.updateChatTimestamp(message.get());
    }

    private void updateChatTimestamp(ChatMessageInfo info) {
        if (info.timestampSeconds().isEmpty()) {
            return;
        }
        long newTimestamp = info.timestampSeconds().getAsLong();
        Long oldTimeStamp = this.newestMessage().map(value -> value.timestampSeconds().orElse(0L)).orElse(0L);
        if (oldTimeStamp > newTimestamp) {
            return;
        }
        this.timestampSeconds = newTimestamp;
    }

    public void removeMessages() {
        this.historySyncMessages.clear();
    }

    public Collection<HistorySyncMessage> messages() {
        return Collections.unmodifiableCollection(this.historySyncMessages);
    }

    @Override
    public Jid toJid() {
        return this.jid();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof Chat)) return false;
        Chat chat = (Chat)o;
        if (this.unreadMessagesCount != chat.unreadMessagesCount) return false;
        if (this.endOfHistoryTransfer != chat.endOfHistoryTransfer) return false;
        if (this.ephemeralMessagesToggleTimeSeconds != chat.ephemeralMessagesToggleTimeSeconds) return false;
        if (this.timestampSeconds != chat.timestampSeconds) return false;
        if (this.notSpam != chat.notSpam) return false;
        if (this.archived != chat.archived) return false;
        if (this.markedAsUnread != chat.markedAsUnread) return false;
        if (this.pinnedTimestampSeconds != chat.pinnedTimestampSeconds) return false;
        if (this.suspended != chat.suspended) return false;
        if (this.terminated != chat.terminated) return false;
        if (this.support != chat.support) return false;
        if (this.shareOwnPhoneNumber != chat.shareOwnPhoneNumber) return false;
        if (this.pnhDuplicateLidThread != chat.pnhDuplicateLidThread) return false;
        if (!Objects.equals(this.jid, chat.jid)) return false;
        if (!Objects.equals(this.historySyncMessages, chat.historySyncMessages)) return false;
        if (!Objects.equals(this.newJid, chat.newJid)) return false;
        if (!Objects.equals(this.oldJid, chat.oldJid)) return false;
        if (this.ephemeralMessageDuration != chat.ephemeralMessageDuration) return false;
        if (this.endOfHistoryTransferType != chat.endOfHistoryTransferType) return false;
        if (!Objects.equals(this.name, chat.name)) return false;
        if (!Objects.equals(this.disappearInitiator, chat.disappearInitiator)) return false;
        if (!Objects.equals(this.mute, chat.mute)) return false;
        if (!Objects.equals(this.wallpaper, chat.wallpaper)) return false;
        if (this.mediaVisibility != chat.mediaVisibility) return false;
        if (!Objects.equals(this.displayName, chat.displayName)) return false;
        if (!Objects.equals(this.phoneJid, chat.phoneJid)) return false;
        if (!Objects.equals(this.lid, chat.lid)) return false;
        if (!Objects.equals(this.presences, chat.presences)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jid, this.historySyncMessages, this.newJid, this.oldJid, this.unreadMessagesCount, this.endOfHistoryTransfer, this.ephemeralMessageDuration, this.ephemeralMessagesToggleTimeSeconds, this.endOfHistoryTransferType, this.timestampSeconds, this.name, this.notSpam, this.archived, this.disappearInitiator, this.markedAsUnread, this.pinnedTimestampSeconds, this.mute, this.wallpaper, this.mediaVisibility, this.suspended, this.terminated, this.support, this.displayName, this.phoneJid, this.shareOwnPhoneNumber, this.pnhDuplicateLidThread, this.lid, this.presences});
    }

    public Jid jid() {
        return this.jid;
    }

    public Collection<HistorySyncMessage> historySyncMessages() {
        return this.historySyncMessages;
    }

    public Optional<Jid> newJid() {
        return Optional.ofNullable(this.newJid);
    }

    public Optional<Jid> oldJid() {
        return Optional.ofNullable(this.oldJid);
    }

    public int unreadMessagesCount() {
        return this.unreadMessagesCount;
    }

    public boolean endOfHistoryTransfer() {
        return this.endOfHistoryTransfer;
    }

    public ChatEphemeralTimer ephemeralMessageDuration() {
        return this.ephemeralMessageDuration;
    }

    public long ephemeralMessagesToggleTimeSeconds() {
        return this.ephemeralMessagesToggleTimeSeconds;
    }

    public Optional<EndOfHistoryTransferType> endOfHistoryTransferType() {
        return Optional.ofNullable(this.endOfHistoryTransferType);
    }

    public long timestampSeconds() {
        return this.timestampSeconds;
    }

    public boolean notSpam() {
        return this.notSpam;
    }

    public boolean archived() {
        return this.archived;
    }

    public Optional<ChatDisappear> disappearInitiator() {
        return Optional.ofNullable(this.disappearInitiator);
    }

    public boolean markedAsUnread() {
        return this.markedAsUnread;
    }

    public int pinnedTimestampSeconds() {
        return this.pinnedTimestampSeconds;
    }

    public ChatMute mute() {
        return this.mute;
    }

    public Optional<ChatWallpaper> wallpaper() {
        return Optional.ofNullable(this.wallpaper);
    }

    public MediaVisibility mediaVisibility() {
        return this.mediaVisibility;
    }

    public boolean suspended() {
        return this.suspended;
    }

    public boolean terminated() {
        return this.terminated;
    }

    public boolean support() {
        return this.support;
    }

    public Optional<Jid> phoneJid() {
        return Optional.ofNullable(this.phoneJid);
    }

    public boolean pnhDuplicateLidThread() {
        return this.pnhDuplicateLidThread;
    }

    public Optional<Jid> lidJid() {
        return Optional.ofNullable(this.lid);
    }

    public ConcurrentHashMap<Jid, ContactStatus> presences() {
        return this.presences;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean shareOwnPhoneNumber() {
        return this.shareOwnPhoneNumber;
    }

    public Chat setUnreadMessagesCount(int unreadMessagesCount) {
        this.unreadMessagesCount = unreadMessagesCount;
        return this;
    }

    public Chat setEndOfHistoryTransfer(boolean endOfHistoryTransfer) {
        this.endOfHistoryTransfer = endOfHistoryTransfer;
        return this;
    }

    public Chat setEphemeralMessageDuration(ChatEphemeralTimer ephemeralMessageDuration) {
        this.ephemeralMessageDuration = ephemeralMessageDuration;
        return this;
    }

    public Chat setEphemeralMessagesToggleTimeSeconds(long ephemeralMessagesToggleTimeSeconds) {
        this.ephemeralMessagesToggleTimeSeconds = ephemeralMessagesToggleTimeSeconds;
        return this;
    }

    public Chat setEndOfHistoryTransferType(EndOfHistoryTransferType endOfHistoryTransferType) {
        this.endOfHistoryTransferType = endOfHistoryTransferType;
        return this;
    }

    public Chat setTimestampSeconds(long timestampSeconds) {
        this.timestampSeconds = timestampSeconds;
        return this;
    }

    public Chat setName(String name) {
        this.name = name;
        return this;
    }

    public Chat setNotSpam(boolean notSpam) {
        this.notSpam = notSpam;
        return this;
    }

    public Chat setArchived(boolean archived) {
        this.archived = archived;
        return this;
    }

    public Chat setDisappearInitiator(ChatDisappear disappearInitiator) {
        this.disappearInitiator = disappearInitiator;
        return this;
    }

    public Chat setMarkedAsUnread(boolean markedAsUnread) {
        this.markedAsUnread = markedAsUnread;
        return this;
    }

    public Chat setPinnedTimestampSeconds(int pinnedTimestampSeconds) {
        this.pinnedTimestampSeconds = pinnedTimestampSeconds;
        return this;
    }

    public Chat setMute(ChatMute mute) {
        this.mute = mute;
        return this;
    }

    public Chat setWallpaper(ChatWallpaper wallpaper) {
        this.wallpaper = wallpaper;
        return this;
    }

    public Chat setMediaVisibility(MediaVisibility mediaVisibility) {
        this.mediaVisibility = mediaVisibility;
        return this;
    }

    public Chat setSuspended(boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    public Chat setTerminated(boolean terminated) {
        this.terminated = terminated;
        return this;
    }

    public Chat setSupport(boolean support) {
        this.support = support;
        return this;
    }

    public Chat setPhoneJid(Jid phoneJid) {
        this.phoneJid = phoneJid;
        return this;
    }

    public Chat setShareOwnPhoneNumber(boolean shareOwnPhoneNumber) {
        this.shareOwnPhoneNumber = shareOwnPhoneNumber;
        return this;
    }

    public Chat setPnhDuplicateLidThread(boolean pnhDuplicateLidThread) {
        this.pnhDuplicateLidThread = pnhDuplicateLidThread;
        return this;
    }

    public Chat setLid(Jid lid) {
        this.lid = lid;
        return this;
    }

    @ProtobufEnum(name="Conversation.EndOfHistoryTransferType")
    public static enum EndOfHistoryTransferType {
        COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY(0),
        COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY(1);

        final int index;

        private EndOfHistoryTransferType(int index) {
            this.index = index;
        }

        public int index() {
            return this.index;
        }
    }
}

