/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.chat;

import it.auties.protobuf.annotation.ProtobufDeserializer;
import it.auties.whatsapp.util.Clock;
import java.time.ZonedDateTime;
import java.util.Optional;

public record ChatMute(long endTimeStamp) {
    private static final long NOT_MUTED_FLAG = 0L;
    private static final long MUTED_INDEFINITELY_FLAG = -1L;
    private static final ChatMute NOT_MUTED = new ChatMute(0L);
    private static final ChatMute MUTED_INDEFINITELY = new ChatMute(-1L);

    public static ChatMute notMuted() {
        return NOT_MUTED;
    }

    public static ChatMute muted() {
        return MUTED_INDEFINITELY;
    }

    public static ChatMute mutedForEightHours() {
        return ChatMute.muted(ZonedDateTime.now().plusHours(8L).toEpochSecond());
    }

    @ProtobufDeserializer
    public static ChatMute ofProtobuf(long object) {
        return ChatMute.muted(object);
    }

    public static ChatMute muted(Long seconds) {
        if (seconds == null || seconds == 0L) {
            return NOT_MUTED;
        }
        if (seconds == -1L) {
            return MUTED_INDEFINITELY;
        }
        return new ChatMute(seconds);
    }

    public static ChatMute mutedForOneWeek() {
        return ChatMute.muted(ZonedDateTime.now().plusWeeks(1L).toEpochSecond());
    }

    public boolean isMuted() {
        return this.type() != Type.NOT_MUTED;
    }

    public Type type() {
        if (this.endTimeStamp == -1L) {
            return Type.MUTED_INDEFINITELY;
        }
        if (this.endTimeStamp == 0L) {
            return Type.NOT_MUTED;
        }
        return Type.MUTED_FOR_TIMEFRAME;
    }

    public Optional<ZonedDateTime> end() {
        return Clock.parseSeconds(this.endTimeStamp);
    }

    public static enum Type {
        MUTED_FOR_TIMEFRAME,
        MUTED_INDEFINITELY,
        NOT_MUTED;

    }
}

