/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.companion;

import it.auties.protobuf.annotation.ProtobufMessage;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.Version;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;

@ProtobufMessage
public final class CompanionDevice {
    private static final List<Map.Entry<String, String>> IPHONES = List.of(Map.entry("iPhone_7", "iPhone12,1"));
    private static final List<Map.Entry<String, String>> IOS_VERSION = List.of(Map.entry("15.8.3", "21G101"));
    private static final int MIDDLEWARE_BUSINESS_PORT = 1120;
    private static final int MIDDLEWARE_PERSONAL_PORT = 1119;
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    private final String model;
    @ProtobufProperty(index=2, type=ProtobufType.STRING)
    private final String manufacturer;
    @ProtobufProperty(index=3, type=ProtobufType.ENUM)
    private final UserAgent.PlatformType platform;
    @ProtobufProperty(index=4, type=ProtobufType.MESSAGE)
    private final Version appVersion;
    @ProtobufProperty(index=5, type=ProtobufType.MESSAGE)
    private final Version osVersion;
    @ProtobufProperty(index=6, type=ProtobufType.STRING)
    private final String osBuildNumber;
    @ProtobufProperty(index=7, type=ProtobufType.STRING)
    private final String address;
    @ProtobufProperty(index=8, type=ProtobufType.STRING)
    private final String modelId;
    @ProtobufProperty(index=9, type=ProtobufType.ENUM)
    private final ClientType clientType;

    private CompanionDevice(String model, String manufacturer, UserAgent.PlatformType platform, Version appVersion, Version osVersion, String osBuildNumber, List<String> addresses, String modelId, ClientType clientType) {
        this(model, manufacturer, platform, appVersion, osVersion, osBuildNumber, addresses == null || addresses.isEmpty() ? null : addresses.get(ThreadLocalRandom.current().nextInt(0, addresses.size())), modelId, clientType);
    }

    CompanionDevice(String model, String manufacturer, UserAgent.PlatformType platform, Version appVersion, Version osVersion, String osBuildNumber, String address, String modelId, ClientType clientType) {
        URI uri;
        this.model = model;
        this.modelId = modelId;
        this.manufacturer = manufacturer;
        this.platform = platform;
        this.appVersion = appVersion;
        this.osVersion = osVersion;
        this.osBuildNumber = osBuildNumber;
        URI uRI = uri = address == null ? null : URI.create(address);
        this.address = uri == null ? null : "%s://%s:%s".formatted(Objects.requireNonNullElse(uri.getScheme(), "http"), Objects.requireNonNull(uri.getHost(), "Missing hostname"), uri.getPort() != -1 ? uri.getPort() : (platform.isBusiness() ? 1120 : 1119));
        this.clientType = clientType;
    }

    public static CompanionDevice web() {
        return CompanionDevice.web(null);
    }

    public static CompanionDevice web(Version appVersion) {
        return new CompanionDevice("Chrome", "Google", UserAgent.PlatformType.WEB, appVersion, Version.of("1.0"), null, List.of(), null, ClientType.WEB);
    }

    public static CompanionDevice ios(boolean business) {
        return CompanionDevice.ios(null, business, null);
    }

    public static CompanionDevice ios(boolean business, String address) {
        return CompanionDevice.ios(null, business, address == null ? null : List.of(address));
    }

    public static CompanionDevice ios(boolean business, List<String> address) {
        return CompanionDevice.ios(null, business, address);
    }

    public static CompanionDevice ios(Version appVersion, boolean business, List<String> address) {
        Map.Entry<String, String> model = IPHONES.get(ThreadLocalRandom.current().nextInt(IPHONES.size()));
        Map.Entry<String, String> version = IOS_VERSION.get(ThreadLocalRandom.current().nextInt(IOS_VERSION.size()));
        return new CompanionDevice(model.getKey(), "Apple", business ? UserAgent.PlatformType.IOS_BUSINESS : UserAgent.PlatformType.IOS, appVersion, Version.of(version.getKey()), version.getValue(), address, model.getValue(), ClientType.MOBILE);
    }

    public static CompanionDevice android(boolean business) {
        return CompanionDevice.android(null, business, null);
    }

    public static CompanionDevice android(boolean business, String address) {
        return CompanionDevice.android(null, business, address == null ? null : List.of(address));
    }

    public static CompanionDevice android(boolean business, List<String> address) {
        return CompanionDevice.android(null, business, address);
    }

    public static CompanionDevice android(Version appVersion, boolean business, List<String> address) {
        String model = "Pixel_" + ThreadLocalRandom.current().nextInt(2, 9);
        return new CompanionDevice(model, "Google", business ? UserAgent.PlatformType.ANDROID_BUSINESS : UserAgent.PlatformType.ANDROID, appVersion, Version.of(String.valueOf(ThreadLocalRandom.current().nextInt(11, 16))), null, address, model, ClientType.MOBILE);
    }

    public static CompanionDevice kaiOs() {
        return CompanionDevice.kaiOs(null);
    }

    public static CompanionDevice kaiOs(Version appVersion) {
        return new CompanionDevice("8110", "Nokia", UserAgent.PlatformType.KAIOS, appVersion, Version.of("2.5.4"), null, List.of(), "8110", ClientType.MOBILE);
    }

    public String osBuildNumber() {
        return Objects.requireNonNullElse(this.osBuildNumber, this.osVersion.toString());
    }

    public Optional<String> toUserAgent(Version appVersion) {
        String deviceName;
        String platformName;
        switch (this.platform()) {
            case ANDROID: {
                String string = "Android";
                break;
            }
            case ANDROID_BUSINESS: {
                String string = "SMBA";
                break;
            }
            case IOS: {
                String string = "iOS";
                break;
            }
            case IOS_BUSINESS: {
                String string = "SMB iOS";
                break;
            }
            case KAIOS: {
                String string = "KaiOS";
                break;
            }
            default: {
                String string = platformName = null;
            }
        }
        if (platformName == null) {
            return Optional.empty();
        }
        switch (this.platform()) {
            case ANDROID: 
            case ANDROID_BUSINESS: {
                Object object = this.manufacturer + "-" + this.model;
                break;
            }
            case IOS: 
            case IOS_BUSINESS: {
                Object object = this.model;
                break;
            }
            case KAIOS: {
                Object object = this.manufacturer + "+" + this.model;
                break;
            }
            default: {
                Object object = deviceName = null;
            }
        }
        if (deviceName == null) {
            return Optional.empty();
        }
        String deviceVersion = this.platform.isKaiOs() ? "%s+20190925153113".formatted(this.osVersion) : this.osVersion.toString();
        return Optional.of("WhatsApp/%s %s/%s Device/%s".formatted(appVersion, platformName, deviceVersion, deviceName));
    }

    public CompanionDevice toPersonal() {
        if (!this.platform.isBusiness()) {
            return this;
        }
        return this.withPlatform(this.platform.toPersonal());
    }

    public CompanionDevice toBusiness() {
        if (this.platform.isBusiness()) {
            return this;
        }
        return this.withPlatform(this.platform.toBusiness());
    }

    public CompanionDevice withPlatform(UserAgent.PlatformType platform) {
        return new CompanionDevice(this.model, this.manufacturer, Objects.requireNonNullElse(platform, this.platform), this.appVersion, this.osVersion, this.osBuildNumber, this.address, this.modelId, this.clientType);
    }

    public String model() {
        return this.model;
    }

    public String modelId() {
        return this.modelId;
    }

    public String manufacturer() {
        return this.manufacturer;
    }

    public UserAgent.PlatformType platform() {
        return this.platform;
    }

    public Optional<Version> appVersion() {
        return Optional.ofNullable(this.appVersion);
    }

    public Version osVersion() {
        return this.osVersion;
    }

    public Optional<String> address() {
        return Optional.ofNullable(this.address);
    }

    public ClientType clientType() {
        return this.clientType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompanionDevice that = (CompanionDevice)o;
        return Objects.equals(this.model, that.model) && Objects.equals(this.manufacturer, that.manufacturer) && this.platform == that.platform && Objects.equals(this.appVersion, that.appVersion) && Objects.equals(this.osVersion, that.osVersion) && Objects.equals(this.osBuildNumber, that.osBuildNumber) && Objects.equals(this.address, that.address) && Objects.equals(this.modelId, that.modelId) && this.clientType == that.clientType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.model, this.manufacturer, this.platform, this.appVersion, this.osVersion, this.osBuildNumber, this.address, this.modelId, this.clientType});
    }

    public String toString() {
        return "CompanionDevice{model='" + this.model + "', manufacturer='" + this.manufacturer + "', platform=" + String.valueOf((Object)this.platform) + ", appVersion=" + String.valueOf(this.appVersion) + ", osVersion=" + String.valueOf(this.osVersion) + ", osBuildNumber='" + this.osBuildNumber + "', address='" + this.address + "', modelId='" + this.modelId + "', clientType=" + String.valueOf((Object)this.clientType) + "}";
    }
}

