/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.companion;

import com.fasterxml.jackson.annotation.JsonCreator;
import it.auties.protobuf.annotation.ProtobufMessage;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.node.Attributes;
import it.auties.whatsapp.model.node.Node;
import it.auties.whatsapp.model.sync.PatchType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@ProtobufMessage
public final class CompanionHashState {
    @ProtobufProperty(index=1, type=ProtobufType.ENUM)
    private PatchType type;
    @ProtobufProperty(index=2, type=ProtobufType.INT64)
    private long version;
    @ProtobufProperty(index=3, type=ProtobufType.BYTES)
    private byte[] hash;
    @ProtobufProperty(index=4, type=ProtobufType.MAP, mapKeyType=ProtobufType.STRING, mapValueType=ProtobufType.BYTES)
    private Map<String, byte[]> indexValueMap;

    public CompanionHashState(PatchType type) {
        this(type, 0L);
    }

    public CompanionHashState(PatchType type, long version) {
        this.type = type;
        this.version = version;
        this.hash = new byte[128];
        this.indexValueMap = new HashMap<String, byte[]>();
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public CompanionHashState(PatchType type, long version, byte[] hash, Map<String, byte[]> indexValueMap) {
        this.type = type;
        this.version = version;
        this.hash = hash;
        this.indexValueMap = indexValueMap;
    }

    private static boolean checkIndexEntryEquality(CompanionHashState that, String thisKey, byte[] thisValue) {
        byte[] thatValue = that.indexValueMap().get(thisKey);
        return thatValue != null && Arrays.equals(thatValue, thisValue);
    }

    public Node toNode() {
        LinkedHashMap<String, Object> attributes = Attributes.of(new Map.Entry[0]).put("name", (Object)this.type).put("version", this.version).put("return_snapshot", this.version == 0L).toMap();
        return Node.of("collection", attributes);
    }

    public CompanionHashState copy() {
        return new CompanionHashState(this.type, this.version, Arrays.copyOf(this.hash, this.hash.length), new HashMap<String, byte[]>(this.indexValueMap));
    }

    private boolean checkIndexEquality(CompanionHashState that) {
        if (this.indexValueMap.size() != that.indexValueMap().size()) {
            return false;
        }
        return this.indexValueMap().entrySet().stream().allMatch(entry -> CompanionHashState.checkIndexEntryEquality(that, (String)entry.getKey(), (byte[])entry.getValue()));
    }

    public PatchType type() {
        return this.type;
    }

    public long version() {
        return this.version;
    }

    public byte[] hash() {
        return this.hash;
    }

    public Map<String, byte[]> indexValueMap() {
        return this.indexValueMap;
    }

    public CompanionHashState setType(PatchType name) {
        this.type = name;
        return this;
    }

    public CompanionHashState setVersion(long version) {
        this.version = version;
        return this;
    }

    public CompanionHashState setHash(byte[] hash) {
        this.hash = hash;
        return this;
    }

    public CompanionHashState setIndexValueMap(Map<String, byte[]> indexValueMap) {
        this.indexValueMap = indexValueMap;
        return this;
    }

    public boolean equals(Object o) {
        CompanionHashState that;
        return o instanceof CompanionHashState && this.version == (that = (CompanionHashState)o).version() && this.type == that.type() && Arrays.equals(this.hash, that.hash()) && this.checkIndexEquality(that);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.type, this.version, this.indexValueMap});
        result = 31 * result + Arrays.hashCode(this.hash);
        return result;
    }
}

