/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.contact;

import ezvcard.Ezvcard;
import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.property.SimpleProperty;
import ezvcard.property.Telephone;
import it.auties.protobuf.annotation.ProtobufDeserializer;
import it.auties.protobuf.annotation.ProtobufSerializer;
import it.auties.whatsapp.model.jid.Jid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public sealed interface ContactCard {
    public static final String BUSINESS_NAME_VCARD_PROPERTY = "X-WA-BIZ-NAME";
    public static final String PHONE_NUMBER_VCARD_PROPERTY = "WAID";
    public static final String DEFAULT_NUMBER_VCARD_TYPE = "CELL";

    @ProtobufDeserializer
    public static ContactCard ofNullable(String vcard) {
        return vcard == null ? null : ContactCard.of(vcard);
    }

    public static ContactCard of(String vcard) {
        try {
            VCard parsed = Ezvcard.parse((String)vcard).first();
            String version = Objects.requireNonNullElse(parsed.getVersion().getVersion(), VCardVersion.V3_0.getVersion());
            Optional<String> name = Optional.ofNullable((String)parsed.getFormattedName().getValue());
            Map<String, List<Jid>> phoneNumbers = parsed.getTelephoneNumbers().stream().filter(ContactCard::isValidPhoneNumber).collect(Collectors.toUnmodifiableMap(ContactCard::getPhoneType, ContactCard::getPhoneValue, ContactCard::joinPhoneNumbers));
            Optional<String> businessName = Optional.ofNullable(parsed.getExtendedProperty(BUSINESS_NAME_VCARD_PROPERTY)).map(SimpleProperty::getValue);
            return new Parsed(version, name, phoneNumbers, businessName);
        }
        catch (Throwable ignored) {
            return new Raw(vcard);
        }
    }

    public static ContactCard of(String name, Jid phoneNumber) {
        return ContactCard.of(name, phoneNumber, null);
    }

    public static ContactCard of(String name, Jid phoneNumber, String businessName) {
        return new Parsed(VCardVersion.V3_0.getVersion(), Optional.ofNullable(name), new HashMap<String, List<Jid>>(Map.of(DEFAULT_NUMBER_VCARD_TYPE, List.of(Objects.requireNonNull(phoneNumber)))), Optional.ofNullable(businessName));
    }

    private static boolean isValidPhoneNumber(Telephone entry) {
        return ContactCard.getPhoneType(entry) != null && entry.getParameter(PHONE_NUMBER_VCARD_PROPERTY) != null;
    }

    private static String getPhoneType(Telephone entry) {
        return entry.getParameters().getType();
    }

    private static List<Jid> getPhoneValue(Telephone entry) {
        return List.of(Jid.of(entry.getParameter(PHONE_NUMBER_VCARD_PROPERTY)));
    }

    private static List<Jid> joinPhoneNumbers(List<Jid> first, List<Jid> second) {
        return Stream.of(first, second).flatMap(Collection::stream).toList();
    }

    @ProtobufSerializer
    public String toVcard();

    public record Parsed(String version, Optional<String> name, Map<String, List<Jid>> phoneNumbers, Optional<String> businessName) implements ContactCard
    {
        public List<Jid> defaultPhoneNumbers() {
            return Objects.requireNonNullElseGet(this.phoneNumbers.get(ContactCard.DEFAULT_NUMBER_VCARD_TYPE), List::of);
        }

        private void addPhoneNumber(VCard vcard, String type, Jid contact) {
            contact.toPhoneNumber().ifPresent(phoneNumber -> {
                Telephone telephone = new Telephone(phoneNumber);
                telephone.getParameters().setType(type);
                telephone.getParameters().put((Object)ContactCard.PHONE_NUMBER_VCARD_PROPERTY, (Object)contact.user());
                vcard.addTelephoneNumber(telephone);
            });
        }

        public void addPhoneNumber(Jid contact) {
            this.addPhoneNumber(ContactCard.DEFAULT_NUMBER_VCARD_TYPE, contact);
        }

        public void addPhoneNumber(String category, Jid contact) {
            List<Jid> oldValue = this.phoneNumbers.get(category);
            if (oldValue == null) {
                this.phoneNumbers.put(category, List.of(contact));
                return;
            }
            ArrayList<Jid> values = new ArrayList<Jid>(oldValue);
            values.add(contact);
            this.phoneNumbers.put(category, Collections.unmodifiableList(values));
        }

        @Override
        @ProtobufSerializer
        public String toVcard() {
            VCard vcard = new VCard();
            vcard.setVersion(VCardVersion.valueOfByStr((String)this.version()));
            vcard.setFormattedName((String)this.name.orElse(null));
            this.phoneNumbers().forEach((type, contacts) -> contacts.forEach(contact -> this.addPhoneNumber(vcard, (String)type, (Jid)contact)));
            this.businessName.ifPresent(value -> vcard.addExtendedProperty(ContactCard.BUSINESS_NAME_VCARD_PROPERTY, value));
            return Ezvcard.write((VCard[])new VCard[]{vcard}).go();
        }
    }

    public record Raw(String toVcard) implements ContactCard
    {
    }
}

