/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.info;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.builtin.ProtobufOptionalMixin;
import it.auties.protobuf.model.ProtobufString;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.AdReplyInfo;
import it.auties.whatsapp.model.info.AdReplyInfoMediaTypeSpec;
import java.nio.ByteBuffer;
import java.util.Optional;

public class AdReplyInfoSpec {
    public static byte[] encode(AdReplyInfo protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)AdReplyInfoSpec.sizeOf(protoInputObject));
        AdReplyInfoSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(AdReplyInfo protoInputObject, ProtobufOutputStream protoOutputStream) {
        ProtobufString caption1;
        String caption0;
        Optional<String> caption;
        ByteBuffer thumbnail1;
        byte[] thumbnail0;
        Optional<byte[]> thumbnail;
        AdReplyInfo.MediaType mediaType;
        ProtobufString advertiserName0;
        if (protoInputObject == null) {
            return;
        }
        String advertiserName = protoInputObject.advertiserName();
        if (advertiserName != null && (advertiserName0 = ProtobufLazyMixin.toValue((String)advertiserName)) != null) {
            protoOutputStream.writeString(1, advertiserName0);
        }
        if ((mediaType = protoInputObject.mediaType()) != null) {
            Integer mediaType0 = AdReplyInfoMediaTypeSpec.encode(mediaType);
            protoOutputStream.writeInt32(2, mediaType0);
        }
        if ((thumbnail = protoInputObject.thumbnail()) != null && (thumbnail0 = (byte[])ProtobufOptionalMixin.toNullableValue(thumbnail)) != null && (thumbnail1 = ProtobufLazyMixin.toValue((byte[])thumbnail0)) != null) {
            protoOutputStream.writeBytes(16, thumbnail1);
        }
        if ((caption = protoInputObject.caption()) != null && (caption0 = (String)ProtobufOptionalMixin.toNullableValue(caption)) != null && (caption1 = ProtobufLazyMixin.toValue((String)caption0)) != null) {
            protoOutputStream.writeString(17, caption1);
        }
    }

    public static AdReplyInfo decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return AdReplyInfoSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static AdReplyInfo decode(ProtobufInputStream protoInputStream) {
        String advertiserName = null;
        AdReplyInfo.MediaType mediaType = null;
        Optional thumbnail = ProtobufOptionalMixin.newOptional();
        Optional caption = ProtobufOptionalMixin.newOptional();
        block6: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    advertiserName = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block6;
                }
                case 2: {
                    mediaType = AdReplyInfoMediaTypeSpec.decode(protoInputStream.readInt32());
                    continue block6;
                }
                case 16: {
                    thumbnail = ProtobufOptionalMixin.ofOptional((Object)ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes()));
                    continue block6;
                }
                case 17: {
                    caption = ProtobufOptionalMixin.ofOptional((Object)ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString()));
                    continue block6;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new AdReplyInfo(advertiserName, mediaType, thumbnail, caption);
    }

    public static int sizeOf(AdReplyInfo protoInputObject) {
        ProtobufString caption1;
        String caption0;
        Optional<String> caption;
        ByteBuffer thumbnail1;
        byte[] thumbnail0;
        Optional<byte[]> thumbnail;
        AdReplyInfo.MediaType mediaType;
        ProtobufString advertiserName0;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        String advertiserName = protoInputObject.advertiserName();
        if (advertiserName != null && (advertiserName0 = ProtobufLazyMixin.toValue((String)advertiserName)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)advertiserName0);
        }
        if ((mediaType = protoInputObject.mediaType()) != null) {
            Integer mediaType0 = AdReplyInfoMediaTypeSpec.encode(mediaType);
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)mediaType0.intValue());
        }
        if ((thumbnail = protoInputObject.thumbnail()) != null && (thumbnail0 = (byte[])ProtobufOptionalMixin.toNullableValue(thumbnail)) != null && (thumbnail1 = ProtobufLazyMixin.toValue((byte[])thumbnail0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)16, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)thumbnail1);
        }
        if ((caption = protoInputObject.caption()) != null && (caption0 = (String)ProtobufOptionalMixin.toNullableValue(caption)) != null && (caption1 = ProtobufLazyMixin.toValue((String)caption0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)17, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)caption1);
        }
        return protoOutputSize;
    }
}

