/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.info;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificate;
import it.auties.whatsapp.model.business.BusinessVerifiedNameCertificateSpec;
import it.auties.whatsapp.model.info.BusinessIdentityInfo;
import it.auties.whatsapp.model.info.BusinessIdentityInfoActorsTypeSpec;
import it.auties.whatsapp.model.info.BusinessIdentityInfoHostStorageTypeSpec;
import it.auties.whatsapp.model.info.BusinessIdentityInfoVerifiedLevelSpec;

public class BusinessIdentityInfoSpec {
    public static byte[] encode(BusinessIdentityInfo protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)BusinessIdentityInfoSpec.sizeOf(protoInputObject));
        BusinessIdentityInfoSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(BusinessIdentityInfo protoInputObject, ProtobufOutputStream protoOutputStream) {
        BusinessIdentityInfo.ActorsType actualActors;
        BusinessVerifiedNameCertificate certificate;
        if (protoInputObject == null) {
            return;
        }
        BusinessIdentityInfo.VerifiedLevel level = protoInputObject.level();
        if (level != null) {
            Integer level0 = BusinessIdentityInfoVerifiedLevelSpec.encode(level);
            protoOutputStream.writeInt32(1, level0);
        }
        if ((certificate = protoInputObject.certificate()) != null) {
            protoOutputStream.writeMessage(2, BusinessVerifiedNameCertificateSpec.sizeOf(certificate));
            BusinessVerifiedNameCertificateSpec.encode(certificate, protoOutputStream);
        }
        boolean signed = protoInputObject.signed();
        protoOutputStream.writeBool(3, Boolean.valueOf(signed));
        boolean revoked = protoInputObject.revoked();
        protoOutputStream.writeBool(4, Boolean.valueOf(revoked));
        BusinessIdentityInfo.HostStorageType hostStorage = protoInputObject.hostStorage();
        if (hostStorage != null) {
            Integer hostStorage0 = BusinessIdentityInfoHostStorageTypeSpec.encode(hostStorage);
            protoOutputStream.writeInt32(5, hostStorage0);
        }
        if ((actualActors = protoInputObject.actualActors()) != null) {
            Integer actualActors0 = BusinessIdentityInfoActorsTypeSpec.encode(actualActors);
            protoOutputStream.writeInt32(6, actualActors0);
        }
        long privacyModeTimestampSeconds = protoInputObject.privacyModeTimestampSeconds();
        protoOutputStream.writeUInt64(7, Long.valueOf(privacyModeTimestampSeconds));
        long featureControls = protoInputObject.featureControls();
        protoOutputStream.writeUInt64(8, Long.valueOf(featureControls));
    }

    public static BusinessIdentityInfo decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return BusinessIdentityInfoSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static BusinessIdentityInfo decode(ProtobufInputStream protoInputStream) {
        BusinessIdentityInfo.VerifiedLevel level = null;
        BusinessVerifiedNameCertificate certificate = null;
        boolean signed = false;
        boolean revoked = false;
        BusinessIdentityInfo.HostStorageType hostStorage = null;
        BusinessIdentityInfo.ActorsType actualActors = null;
        long privacyModeTimestampSeconds = 0L;
        long featureControls = 0L;
        block10: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    level = BusinessIdentityInfoVerifiedLevelSpec.decode(protoInputStream.readInt32());
                    continue block10;
                }
                case 2: {
                    certificate = BusinessVerifiedNameCertificateSpec.decode(protoInputStream.readLengthDelimited());
                    continue block10;
                }
                case 3: {
                    signed = protoInputStream.readBool();
                    continue block10;
                }
                case 4: {
                    revoked = protoInputStream.readBool();
                    continue block10;
                }
                case 5: {
                    hostStorage = BusinessIdentityInfoHostStorageTypeSpec.decode(protoInputStream.readInt32());
                    continue block10;
                }
                case 6: {
                    actualActors = BusinessIdentityInfoActorsTypeSpec.decode(protoInputStream.readInt32());
                    continue block10;
                }
                case 7: {
                    privacyModeTimestampSeconds = protoInputStream.readInt64();
                    continue block10;
                }
                case 8: {
                    featureControls = protoInputStream.readInt64();
                    continue block10;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new BusinessIdentityInfo(level, certificate, signed, revoked, hostStorage, actualActors, privacyModeTimestampSeconds, featureControls);
    }

    public static int sizeOf(BusinessIdentityInfo protoInputObject) {
        BusinessIdentityInfo.ActorsType actualActors;
        BusinessVerifiedNameCertificate certificate;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        BusinessIdentityInfo.VerifiedLevel level = protoInputObject.level();
        if (level != null) {
            Integer level0 = BusinessIdentityInfoVerifiedLevelSpec.encode(level);
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)level0.intValue());
        }
        if ((certificate = protoInputObject.certificate()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            int certificateSerializedSize = BusinessVerifiedNameCertificateSpec.sizeOf(certificate);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)certificateSerializedSize);
            protoOutputSize += certificateSerializedSize;
        }
        boolean signed = protoInputObject.signed();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)0);
        ++protoOutputSize;
        boolean revoked = protoInputObject.revoked();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)0);
        ++protoOutputSize;
        BusinessIdentityInfo.HostStorageType hostStorage = protoInputObject.hostStorage();
        if (hostStorage != null) {
            Integer hostStorage0 = BusinessIdentityInfoHostStorageTypeSpec.encode(hostStorage);
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)5, (int)2);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)hostStorage0.intValue());
        }
        if ((actualActors = protoInputObject.actualActors()) != null) {
            Integer actualActors0 = BusinessIdentityInfoActorsTypeSpec.encode(actualActors);
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)6, (int)2);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)actualActors0.intValue());
        }
        long privacyModeTimestampSeconds = protoInputObject.privacyModeTimestampSeconds();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)7, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)privacyModeTimestampSeconds);
        long featureControls = protoInputObject.featureControls();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)8, (int)0);
        return protoOutputSize += ProtobufOutputStream.getVarIntSize((long)featureControls);
    }
}

