/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.info;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.builtin.ProtobufOptionalMixin;
import it.auties.protobuf.model.ProtobufString;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.NotificationMessageInfo;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.ChatMessageKeySpec;
import it.auties.whatsapp.model.message.model.MessageContainer;
import it.auties.whatsapp.model.message.model.MessageContainerSpec;
import java.util.Optional;

public class NotificationMessageInfoSpec {
    public static byte[] encode(NotificationMessageInfo protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)NotificationMessageInfoSpec.sizeOf(protoInputObject));
        NotificationMessageInfoSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(NotificationMessageInfo protoInputObject, ProtobufOutputStream protoOutputStream) {
        ProtobufString participant1;
        String participant0;
        MessageContainer message;
        if (protoInputObject == null) {
            return;
        }
        ChatMessageKey key = protoInputObject.key();
        if (key != null) {
            protoOutputStream.writeMessage(1, ChatMessageKeySpec.sizeOf(key));
            ChatMessageKeySpec.encode(key, protoOutputStream);
        }
        if ((message = protoInputObject.message()) != null) {
            protoOutputStream.writeMessage(2, MessageContainerSpec.sizeOf(message));
            MessageContainerSpec.encode(message, protoOutputStream);
        }
        long messageTimestampSeconds = protoInputObject.messageTimestampSeconds();
        protoOutputStream.writeUInt64(3, Long.valueOf(messageTimestampSeconds));
        Optional<String> participant = protoInputObject.participant();
        if (participant != null && (participant0 = (String)ProtobufOptionalMixin.toNullableValue(participant)) != null && (participant1 = ProtobufLazyMixin.toValue((String)participant0)) != null) {
            protoOutputStream.writeString(4, participant1);
        }
    }

    public static NotificationMessageInfo decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return NotificationMessageInfoSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static NotificationMessageInfo decode(ProtobufInputStream protoInputStream) {
        ChatMessageKey key = null;
        MessageContainer message = null;
        long messageTimestampSeconds = 0L;
        Optional participant = ProtobufOptionalMixin.newOptional();
        block6: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    key = ChatMessageKeySpec.decode(protoInputStream.readLengthDelimited());
                    continue block6;
                }
                case 2: {
                    message = MessageContainerSpec.decode(protoInputStream.readLengthDelimited());
                    continue block6;
                }
                case 3: {
                    messageTimestampSeconds = protoInputStream.readInt64();
                    continue block6;
                }
                case 4: {
                    participant = ProtobufOptionalMixin.ofOptional((Object)ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString()));
                    continue block6;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new NotificationMessageInfo(key, message, messageTimestampSeconds, participant);
    }

    public static int sizeOf(NotificationMessageInfo protoInputObject) {
        ProtobufString participant1;
        String participant0;
        MessageContainer message;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        ChatMessageKey key = protoInputObject.key();
        if (key != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            int keySerializedSize = ChatMessageKeySpec.sizeOf(key);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)keySerializedSize);
            protoOutputSize += keySerializedSize;
        }
        if ((message = protoInputObject.message()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            int messageSerializedSize = MessageContainerSpec.sizeOf(message);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)messageSerializedSize);
            protoOutputSize += messageSerializedSize;
        }
        long messageTimestampSeconds = protoInputObject.messageTimestampSeconds();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)messageTimestampSeconds);
        Optional<String> participant = protoInputObject.participant();
        if (participant != null && (participant0 = (String)ProtobufOptionalMixin.toNullableValue(participant)) != null && (participant1 = ProtobufLazyMixin.toValue((String)participant0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)participant1);
        }
        return protoOutputSize;
    }
}

