/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.info;

import it.auties.protobuf.builtin.ProtobufRepeatedMixin;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.whatsapp.model.info.ChatMessageInfoSpec;
import it.auties.whatsapp.model.info.WebNotificationsInfo;
import java.util.List;

public class WebNotificationsInfoSpec {
    public static byte[] encode(WebNotificationsInfo protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)WebNotificationsInfoSpec.sizeOf(protoInputObject));
        WebNotificationsInfoSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(WebNotificationsInfo protoInputObject, ProtobufOutputStream protoOutputStream) {
        if (protoInputObject == null) {
            return;
        }
        long timestampSeconds = protoInputObject.timestampSeconds();
        protoOutputStream.writeUInt64(2, Long.valueOf(timestampSeconds));
        int unreadChats = protoInputObject.unreadChats();
        protoOutputStream.writeUInt32(3, Integer.valueOf(unreadChats));
        int notifyMessageCount = protoInputObject.notifyMessageCount();
        protoOutputStream.writeUInt32(4, Integer.valueOf(notifyMessageCount));
        if (protoInputObject.notifyMessages() != null) {
            for (ChatMessageInfo notifyMessagesEntry : protoInputObject.notifyMessages()) {
                if (notifyMessagesEntry == null) continue;
                protoOutputStream.writeMessage(5, ChatMessageInfoSpec.sizeOf(notifyMessagesEntry));
                ChatMessageInfoSpec.encode(notifyMessagesEntry, protoOutputStream);
            }
        }
    }

    public static WebNotificationsInfo decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return WebNotificationsInfoSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static WebNotificationsInfo decode(ProtobufInputStream protoInputStream) {
        long timestampSeconds = 0L;
        int unreadChats = 0;
        int notifyMessageCount = 0;
        List notifyMessages = ProtobufRepeatedMixin.newList();
        block6: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 2: {
                    timestampSeconds = protoInputStream.readInt64();
                    continue block6;
                }
                case 3: {
                    unreadChats = protoInputStream.readInt32();
                    continue block6;
                }
                case 4: {
                    notifyMessageCount = protoInputStream.readInt32();
                    continue block6;
                }
                case 5: {
                    notifyMessages.add(ChatMessageInfoSpec.decode(protoInputStream.readLengthDelimited()));
                    continue block6;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new WebNotificationsInfo(timestampSeconds, unreadChats, notifyMessageCount, notifyMessages);
    }

    public static int sizeOf(WebNotificationsInfo protoInputObject) {
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        long timestampSeconds = protoInputObject.timestampSeconds();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)timestampSeconds);
        int unreadChats = protoInputObject.unreadChats();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)unreadChats);
        int notifyMessageCount = protoInputObject.notifyMessageCount();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)notifyMessageCount);
        if (protoInputObject.notifyMessages() != null) {
            for (ChatMessageInfo notifyMessagesEntry : protoInputObject.notifyMessages()) {
                if (notifyMessagesEntry == null) continue;
                protoOutputSize += ProtobufOutputStream.getFieldSize((int)5, (int)2);
                int notifyMessagesEntrySerializedSize = ChatMessageInfoSpec.sizeOf(notifyMessagesEntry);
                protoOutputSize += ProtobufOutputStream.getVarIntSize((long)notifyMessagesEntrySerializedSize);
                protoOutputSize += notifyMessagesEntrySerializedSize;
            }
        }
        return protoOutputSize;
    }
}

