/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.jid;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import it.auties.protobuf.annotation.ProtobufDeserializer;
import it.auties.protobuf.annotation.ProtobufSerializer;
import it.auties.whatsapp.model.jid.JidProvider;
import it.auties.whatsapp.model.jid.JidServer;
import it.auties.whatsapp.model.jid.JidType;
import it.auties.whatsapp.model.signal.session.SessionAddress;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public final class Jid
implements JidProvider {
    private final String user;
    private final JidServer server;
    private final int device;
    private final int agent;

    private Jid(String user, JidServer server, int device, int agent) {
        this.user = user;
        this.server = server;
        this.device = device;
        this.agent = agent;
    }

    public static Jid of(String user, JidServer server, int device, int agent) {
        return new Jid(Jid.hasPhoneNumberPrefix(user) ? user.substring(1) : user, server, device, agent);
    }

    private static boolean hasPhoneNumberPrefix(String user) {
        return user != null && !user.isEmpty() && user.charAt(0) == '+';
    }

    @ProtobufDeserializer
    @JsonCreator
    public static Jid of(String jid) {
        if (jid == null) {
            return null;
        }
        int separator = jid.indexOf("@");
        if (separator == -1) {
            return Jid.parseJid(jid, jid.length(), JidServer.whatsapp());
        }
        return Jid.parseJid(jid, separator, JidServer.of(jid.substring(separator + 1)));
    }

    public static Jid of(JidServer server) {
        return new Jid(null, server, 0, 0);
    }

    public static Jid of(long jid) {
        return new Jid(String.valueOf(jid), JidServer.whatsapp(), 0, 0);
    }

    public static Jid of(String jid, JidServer server) {
        int separator = jid.indexOf("@");
        return Jid.parseJid(jid, separator == -1 ? jid.length() : separator, server);
    }

    private static Jid parseJid(String complexUser, int length, JidServer server) {
        boolean hasAgent;
        int offset = Jid.hasPhoneNumberPrefix(complexUser) ? 1 : 0;
        int deviceSeparator = complexUser.indexOf(":", 0, length);
        int agentSeparator = complexUser.indexOf("_", 0, length);
        boolean hasDevice = deviceSeparator != -1;
        boolean bl = hasAgent = agentSeparator != -1;
        if (hasDevice && hasAgent) {
            String user = complexUser.substring(offset, Math.min(deviceSeparator, agentSeparator));
            OptionalInt maybeDevice = Jid.tryParseInt(complexUser.substring(deviceSeparator + 1, agentSeparator > deviceSeparator ? agentSeparator : length));
            if (maybeDevice.isEmpty()) {
                return new Jid(Jid.getOrCopyUser(complexUser, length, offset), server, 0, 0);
            }
            OptionalInt maybeAgent = Jid.tryParseInt(complexUser.substring(agentSeparator + 1, deviceSeparator > agentSeparator ? deviceSeparator : length));
            if (maybeAgent.isEmpty()) {
                return new Jid(Jid.getOrCopyUser(complexUser, length, offset), server, 0, 0);
            }
            return new Jid(user, server, maybeDevice.getAsInt(), maybeAgent.getAsInt());
        }
        if (hasDevice) {
            String user = complexUser.substring(offset, deviceSeparator);
            OptionalInt maybeDevice = Jid.tryParseInt(complexUser.substring(deviceSeparator + 1, length));
            if (maybeDevice.isEmpty()) {
                return new Jid(Jid.getOrCopyUser(complexUser, length, offset), server, 0, 0);
            }
            return new Jid(user, server, maybeDevice.getAsInt(), 0);
        }
        if (hasAgent) {
            String user = complexUser.substring(offset, agentSeparator);
            OptionalInt maybeAgent = Jid.tryParseInt(complexUser.substring(agentSeparator + 1, length));
            if (maybeAgent.isEmpty()) {
                return new Jid(Jid.getOrCopyUser(complexUser, length, offset), server, 0, 0);
            }
            return new Jid(user, server, 0, maybeAgent.getAsInt());
        }
        return new Jid(Jid.getOrCopyUser(complexUser, length, offset), server, 0, 0);
    }

    private static String getOrCopyUser(String complexUser, int length, int offset) {
        if (offset == 0 && length == complexUser.length()) {
            return complexUser;
        }
        return complexUser.substring(offset, length);
    }

    private static OptionalInt tryParseInt(String string) {
        try {
            return OptionalInt.of(Integer.parseUnsignedInt(string));
        }
        catch (NumberFormatException exception) {
            return OptionalInt.empty();
        }
    }

    public JidType type() {
        JidType jidType;
        if (this.isCompanion()) {
            jidType = JidType.COMPANION;
        } else {
            JidServer jidServer = this.server();
            Objects.requireNonNull(jidServer);
            JidServer jidServer2 = jidServer;
            int n = 0;
            block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JidServer.Whatsapp.class, JidServer.Lid.class, JidServer.Broadcast.class, JidServer.GroupOrCommunity.class, JidServer.GroupCall.class, JidServer.Newsletter.class, JidServer.User.class, JidServer.Unknown.class}, (Object)jidServer2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    JidServer.Whatsapp ignored = (JidServer.Whatsapp)jidServer2;
                    if (Objects.equals(this.user(), "16505361212")) {
                        jidType = JidType.OFFICIAL_SURVEY_ACCOUNT;
                        break;
                    }
                    jidType = JidType.USER;
                    break;
                }
                case 1: {
                    JidServer.Lid ignored = (JidServer.Lid)jidServer2;
                    jidType = JidType.LID;
                    break;
                }
                case 2: {
                    JidServer.Broadcast ignored = (JidServer.Broadcast)jidServer2;
                    if (Objects.equals(this.user(), "status")) {
                        jidType = JidType.STATUS;
                        break;
                    }
                    jidType = JidType.BROADCAST;
                    break;
                }
                case 3: {
                    JidServer.GroupOrCommunity ignored = (JidServer.GroupOrCommunity)jidServer2;
                    jidType = JidType.GROUP;
                    break;
                }
                case 4: {
                    JidServer.GroupCall ignored = (JidServer.GroupCall)jidServer2;
                    jidType = JidType.GROUP_CALL;
                    break;
                }
                case 5: {
                    JidServer.Newsletter ignored = (JidServer.Newsletter)jidServer2;
                    jidType = JidType.NEWSLETTER;
                    break;
                }
                case 6: {
                    JidServer.User ignored = (JidServer.User)jidServer2;
                    String string = this.user();
                    int n2 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"server", "0", "16508638904", "16505361212"}, (Object)string, n2)) {
                        case 0: {
                            jidType = JidType.SERVER;
                            break block0;
                        }
                        case 1: {
                            jidType = JidType.ANNOUNCEMENT;
                            break block0;
                        }
                        case 2: {
                            jidType = JidType.IAS;
                            break block0;
                        }
                        case 3: {
                            jidType = JidType.OFFICIAL_BUSINESS_ACCOUNT;
                            break block0;
                        }
                    }
                    jidType = JidType.UNKNOWN;
                    break;
                }
                case 7: {
                    JidServer.Unknown ignored = (JidServer.Unknown)jidServer2;
                    jidType = JidType.UNKNOWN;
                }
            }
        }
        return jidType;
    }

    public boolean isCompanion() {
        return this.device() != 0;
    }

    public boolean hasServer(JidServer server) {
        return this.server.equals(server);
    }

    public boolean isServerJid(JidServer server) {
        return this.user == null && this.server.equals(server);
    }

    public Jid withServer(JidServer server) {
        return new Jid(this.user(), server, this.device, this.agent);
    }

    public Jid withoutAgent() {
        return new Jid(this.user, this.server, this.device, 0);
    }

    public Jid withAgent(int agent) {
        return new Jid(this.user, this.server, this.device, agent);
    }

    public Jid withoutDevice() {
        return new Jid(this.user, this.server, 0, this.agent);
    }

    public Jid withDevice(int device) {
        return new Jid(this.user, this.server, device, this.agent);
    }

    public Jid toSimpleJid() {
        return new Jid(this.user, this.server, 0, 0);
    }

    public Optional<String> toPhoneNumber() {
        try {
            Long.parseLong(this.user);
            return Optional.of("+" + this.user);
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    @JsonValue
    @ProtobufSerializer
    public String toString() {
        boolean hasUser = this.hasUser();
        boolean hasAgent = this.hasAgent();
        boolean hasDevice = this.hasDevice();
        if (!(hasUser || hasAgent || hasDevice)) {
            return this.server.toString();
        }
        String user = hasUser ? this.user : "";
        String agent = hasAgent ? "_" + this.agent : "";
        String device = hasDevice ? ":" + this.device : "";
        return user + agent + device + "@" + this.server.toString();
    }

    public SessionAddress toSignalAddress() {
        return new SessionAddress(this.user, this.device);
    }

    @Override
    public Jid toJid() {
        return this;
    }

    public String user() {
        return this.user;
    }

    public JidServer server() {
        return this.server;
    }

    public int device() {
        return this.device;
    }

    public int agent() {
        return this.agent;
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public boolean hasDevice() {
        return this.device != 0;
    }

    public boolean hasAgent() {
        return this.agent != 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Jid that = (Jid)obj;
        return Objects.equals(this.user, that.user) && Objects.equals(this.server, that.server) && this.device == that.device && this.agent == that.agent;
    }

    public int hashCode() {
        return Objects.hash(this.user, this.server, this.device, this.agent);
    }
}

