/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.jid;

import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.jid.JidProvider;
import java.util.Objects;

public sealed interface JidServer
extends JidProvider {
    public String address();

    @Override
    default public Jid toJid() {
        return Jid.of(this);
    }

    public static JidServer user() {
        return User.INSTANCE;
    }

    public static JidServer groupOrCommunity() {
        return GroupOrCommunity.INSTANCE;
    }

    public static JidServer broadcast() {
        return Broadcast.INSTANCE;
    }

    public static JidServer groupCall() {
        return GroupCall.INSTANCE;
    }

    public static JidServer whatsapp() {
        return Whatsapp.INSTANCE;
    }

    public static JidServer lid() {
        return Lid.INSTANCE;
    }

    public static JidServer newsletter() {
        return Newsletter.INSTANCE;
    }

    public static JidServer unknown(String address) {
        return new Unknown(address);
    }

    public static JidServer of(String address) {
        return switch (address) {
            case "c.us" -> User.INSTANCE;
            case "g.us" -> GroupOrCommunity.INSTANCE;
            case "broadcast" -> Broadcast.INSTANCE;
            case "call" -> GroupCall.INSTANCE;
            case "s.whatsapp.net" -> Whatsapp.INSTANCE;
            case "lid" -> Lid.INSTANCE;
            case "newsletter" -> Newsletter.INSTANCE;
            default -> new Unknown(address);
        };
    }

    public static final class User
    implements JidServer {
        private static final String ADDRESS = "c.us";
        private static final User INSTANCE = new User();

        private User() {
        }

        @Override
        public String address() {
            return ADDRESS;
        }

        public String toString() {
            return this.address();
        }
    }

    public static final class GroupOrCommunity
    implements JidServer {
        private static final String ADDRESS = "g.us";
        private static final GroupOrCommunity INSTANCE = new GroupOrCommunity();

        private GroupOrCommunity() {
        }

        @Override
        public String address() {
            return ADDRESS;
        }

        public String toString() {
            return this.address();
        }
    }

    public static final class Broadcast
    implements JidServer {
        private static final String ADDRESS = "broadcast";
        private static final Broadcast INSTANCE = new Broadcast();

        private Broadcast() {
        }

        @Override
        public String address() {
            return ADDRESS;
        }

        public String toString() {
            return this.address();
        }
    }

    public static final class GroupCall
    implements JidServer {
        private static final String ADDRESS = "call";
        private static final GroupCall INSTANCE = new GroupCall();

        private GroupCall() {
        }

        @Override
        public String address() {
            return ADDRESS;
        }

        public String toString() {
            return this.address();
        }
    }

    public static final class Whatsapp
    implements JidServer {
        private static final String ADDRESS = "s.whatsapp.net";
        private static final Whatsapp INSTANCE = new Whatsapp();

        private Whatsapp() {
        }

        @Override
        public String address() {
            return ADDRESS;
        }

        public String toString() {
            return this.address();
        }
    }

    public static final class Lid
    implements JidServer {
        private static final String ADDRESS = "lid";
        private static final Lid INSTANCE = new Lid();

        private Lid() {
        }

        @Override
        public String address() {
            return ADDRESS;
        }

        public String toString() {
            return this.address();
        }
    }

    public static final class Newsletter
    implements JidServer {
        private static final String ADDRESS = "newsletter";
        private static final Newsletter INSTANCE = new Newsletter();

        private Newsletter() {
        }

        @Override
        public String address() {
            return ADDRESS;
        }

        public String toString() {
            return this.address();
        }
    }

    public static final class Unknown
    implements JidServer {
        private final String address;

        private Unknown(String address) {
            this.address = Objects.requireNonNull(address, "Invalid address");
        }

        @Override
        public String address() {
            return this.address;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Unknown that = (Unknown)obj;
            return Objects.equals(this.address, that.address);
        }

        public int hashCode() {
            return Objects.hash(this.address);
        }

        public String toString() {
            return this.address;
        }
    }
}

