/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import it.auties.protobuf.annotation.ProtobufMessage;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.crypto.MD5;
import it.auties.whatsapp.crypto.Sha256;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.jid.JidServer;
import it.auties.whatsapp.util.Bytes;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.HexFormat;
import java.util.Objects;
import java.util.Optional;

@ProtobufMessage(name="MessageKey")
public final class ChatMessageKey {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    private Jid chatJid;
    @ProtobufProperty(index=2, type=ProtobufType.BOOL)
    private final boolean fromMe;
    @ProtobufProperty(index=3, type=ProtobufType.STRING)
    private final String id;
    @ProtobufProperty(index=4, type=ProtobufType.STRING)
    private Jid senderJid;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public ChatMessageKey(Jid chatJid, boolean fromMe, String id, Jid senderJid) {
        this.chatJid = chatJid;
        this.fromMe = fromMe;
        this.id = Objects.requireNonNull(id);
        this.senderJid = senderJid;
    }

    public static String randomIdV2(Jid jid, ClientType clientType) {
        return switch (clientType) {
            default -> throw new MatchException(null, null);
            case ClientType.WEB -> {
                String meUser = "%s@%s".formatted(jid.user(), "@c.us");
                long timeSeconds = Instant.now().getEpochSecond();
                byte[] randomBytes = Bytes.random(16);
                ByteBuffer buffer = ByteBuffer.allocate(8 + meUser.length() + randomBytes.length);
                buffer.putLong(timeSeconds);
                buffer.put(meUser.getBytes());
                buffer.put(randomBytes);
                yield "3EB0" + HexFormat.of().formatHex(Sha256.calculate(buffer.array()), 0, 9).toUpperCase();
            }
            case ClientType.MOBILE -> {
                Jid meJid = Objects.requireNonNullElse(jid, Jid.of(JidServer.whatsapp()));
                byte[] meUser = meJid.toSimpleJid().toString().getBytes();
                long timeMillis = System.currentTimeMillis();
                byte[] timeArray = new byte[8];
                for (int i = 7; i >= 0; --i) {
                    timeArray[i] = (byte)timeMillis;
                    timeMillis >>= 8;
                }
                byte[] digested = MD5.calculate(Bytes.concat(timeArray, meUser, Bytes.random(16)));
                char[] cArr = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
                char[] cArr2 = new char[digested.length * 2];
                int i = 0;
                for (byte b : digested) {
                    int i2 = b & 0xFF;
                    int i3 = i + 1;
                    cArr2[i] = cArr[i2 >>> 4];
                    i = i3 + 1;
                    cArr2[i3] = cArr[i2 & 0xF];
                }
                yield new String(cArr2);
            }
        };
    }

    public Jid chatJid() {
        return this.chatJid;
    }

    public ChatMessageKey setChatJid(Jid chatJid) {
        this.chatJid = chatJid;
        return this;
    }

    public boolean fromMe() {
        return this.fromMe;
    }

    public String id() {
        return this.id;
    }

    public Optional<Jid> senderJid() {
        return Optional.ofNullable(this.senderJid);
    }

    public ChatMessageKey setSenderJid(Jid senderJid) {
        this.senderJid = senderJid;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof ChatMessageKey)) return false;
        ChatMessageKey that = (ChatMessageKey)o;
        if (this.fromMe != that.fromMe) return false;
        if (!Objects.equals(this.chatJid, that.chatJid)) return false;
        if (!Objects.equals(this.id, that.id)) return false;
        if (!Objects.equals(this.senderJid, that.senderJid)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.chatJid, this.fromMe, this.id, this.senderJid);
    }
}

