/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.model;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.model.ProtobufString;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.ChatMessageKeySpec;
import it.auties.whatsapp.model.message.model.KeepInChat;
import it.auties.whatsapp.model.message.model.KeepInChatType;
import it.auties.whatsapp.model.message.model.KeepInChatTypeSpec;

public class KeepInChatSpec {
    public static byte[] encode(KeepInChat protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)KeepInChatSpec.sizeOf(protoInputObject));
        KeepInChatSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(KeepInChat protoInputObject, ProtobufOutputStream protoOutputStream) {
        ProtobufString deviceJid1;
        String deviceJid0;
        Jid deviceJid;
        if (protoInputObject == null) {
            return;
        }
        KeepInChatType keepType = protoInputObject.keepType();
        if (keepType != null) {
            Integer keepType0 = KeepInChatTypeSpec.encode(keepType);
            protoOutputStream.writeInt32(1, keepType0);
        }
        long serverTimestampSeconds = protoInputObject.serverTimestampSeconds();
        protoOutputStream.writeInt64(2, Long.valueOf(serverTimestampSeconds));
        ChatMessageKey key = protoInputObject.key();
        if (key != null) {
            protoOutputStream.writeMessage(3, ChatMessageKeySpec.sizeOf(key));
            ChatMessageKeySpec.encode(key, protoOutputStream);
        }
        if ((deviceJid = protoInputObject.deviceJid()) != null && (deviceJid0 = deviceJid.toString()) != null && (deviceJid1 = ProtobufLazyMixin.toValue((String)deviceJid0)) != null) {
            protoOutputStream.writeString(4, deviceJid1);
        }
        long clientTimestampInMilliseconds = protoInputObject.clientTimestampInMilliseconds();
        protoOutputStream.writeInt64(5, Long.valueOf(clientTimestampInMilliseconds));
        long serverTimestampMilliseconds = protoInputObject.serverTimestampMilliseconds();
        protoOutputStream.writeInt64(6, Long.valueOf(serverTimestampMilliseconds));
    }

    public static KeepInChat decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return KeepInChatSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static KeepInChat decode(ProtobufInputStream protoInputStream) {
        KeepInChatType keepType = null;
        long serverTimestampSeconds = 0L;
        ChatMessageKey key = null;
        Jid deviceJid = null;
        long clientTimestampInMilliseconds = 0L;
        long serverTimestampMilliseconds = 0L;
        block8: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    keepType = KeepInChatTypeSpec.decode(protoInputStream.readInt32());
                    continue block8;
                }
                case 2: {
                    serverTimestampSeconds = protoInputStream.readInt64();
                    continue block8;
                }
                case 3: {
                    key = ChatMessageKeySpec.decode(protoInputStream.readLengthDelimited());
                    continue block8;
                }
                case 4: {
                    deviceJid = Jid.of(ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString()));
                    continue block8;
                }
                case 5: {
                    clientTimestampInMilliseconds = protoInputStream.readInt64();
                    continue block8;
                }
                case 6: {
                    serverTimestampMilliseconds = protoInputStream.readInt64();
                    continue block8;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new KeepInChat(keepType, serverTimestampSeconds, key, deviceJid, clientTimestampInMilliseconds, serverTimestampMilliseconds);
    }

    public static int sizeOf(KeepInChat protoInputObject) {
        ProtobufString deviceJid1;
        String deviceJid0;
        Jid deviceJid;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        KeepInChatType keepType = protoInputObject.keepType();
        if (keepType != null) {
            Integer keepType0 = KeepInChatTypeSpec.encode(keepType);
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)keepType0.intValue());
        }
        long serverTimestampSeconds = protoInputObject.serverTimestampSeconds();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)serverTimestampSeconds);
        ChatMessageKey key = protoInputObject.key();
        if (key != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)2);
            int keySerializedSize = ChatMessageKeySpec.sizeOf(key);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)keySerializedSize);
            protoOutputSize += keySerializedSize;
        }
        if ((deviceJid = protoInputObject.deviceJid()) != null && (deviceJid0 = deviceJid.toString()) != null && (deviceJid1 = ProtobufLazyMixin.toValue((String)deviceJid0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)deviceJid1);
        }
        long clientTimestampInMilliseconds = protoInputObject.clientTimestampInMilliseconds();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)5, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)clientTimestampInMilliseconds);
        long serverTimestampMilliseconds = protoInputObject.serverTimestampMilliseconds();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)6, (int)0);
        return protoOutputSize += ProtobufOutputStream.getVarIntSize((long)serverTimestampMilliseconds);
    }
}

