/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.model;

import it.auties.whatsapp.model.media.AttachmentType;
import it.auties.whatsapp.model.media.MutableAttachmentProvider;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.message.model.MediaMessageType;
import it.auties.whatsapp.model.message.model.MessageCategory;
import it.auties.whatsapp.model.message.model.MessageType;
import it.auties.whatsapp.model.message.payment.PaymentInvoiceMessage;
import it.auties.whatsapp.model.message.standard.AudioMessage;
import it.auties.whatsapp.model.message.standard.DocumentMessage;
import it.auties.whatsapp.model.message.standard.ImageMessage;
import it.auties.whatsapp.model.message.standard.StickerMessage;
import it.auties.whatsapp.model.message.standard.VideoOrGifMessage;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.OptionalLong;

public abstract sealed class MediaMessage<T extends MediaMessage<T>>
implements ContextualMessage<T>,
MutableAttachmentProvider<T>
permits PaymentInvoiceMessage, AudioMessage, DocumentMessage, ImageMessage, StickerMessage, VideoOrGifMessage {
    private byte[] decodedMedia;
    private String handle;

    public Optional<String> handle() {
        return Optional.ofNullable(this.handle);
    }

    public Optional<byte[]> decodedMedia() {
        return Optional.ofNullable(this.decodedMedia);
    }

    public abstract OptionalLong mediaKeyTimestampSeconds();

    public abstract Optional<ZonedDateTime> mediaKeyTimestamp();

    public abstract MediaMessageType mediaType();

    @Override
    public MessageCategory category() {
        return MessageCategory.MEDIA;
    }

    @Override
    public MessageType type() {
        return this.mediaType().toMessageType();
    }

    @Override
    public AttachmentType attachmentType() {
        return this.mediaType().toAttachmentType();
    }

    public T setDecodedMedia(byte[] decodedMedia) {
        this.decodedMedia = decodedMedia;
        return (T)this;
    }

    public T setHandle(String handle) {
        this.handle = handle;
        return (T)this;
    }
}

