/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.model;

import it.auties.whatsapp.model.media.AttachmentType;
import it.auties.whatsapp.model.message.model.MessageType;

public enum MediaMessageType {
    NONE("", "", MessageType.EMPTY, AttachmentType.NONE),
    IMAGE("jpg", "image/jpeg", MessageType.IMAGE, AttachmentType.IMAGE),
    DOCUMENT("", "application/octet-stream", MessageType.DOCUMENT, AttachmentType.DOCUMENT),
    AUDIO("mp3", "audio/mpeg", MessageType.AUDIO, AttachmentType.AUDIO),
    VIDEO("mp4", "video/mp4", MessageType.VIDEO, AttachmentType.VIDEO),
    STICKER("webp", "image/webp", MessageType.STICKER, AttachmentType.IMAGE);

    private final String extension;
    private final String mimeType;
    private final MessageType messageType;
    private final AttachmentType attachmentType;

    private MediaMessageType(String extension, String mimeType, MessageType messageType, AttachmentType attachmentType) {
        this.extension = extension;
        this.mimeType = mimeType;
        this.messageType = messageType;
        this.attachmentType = attachmentType;
    }

    public MessageType toMessageType() {
        return this.messageType;
    }

    public AttachmentType toAttachmentType() {
        return this.attachmentType;
    }

    public String extension() {
        return this.extension;
    }

    public String mimeType() {
        return this.mimeType;
    }
}

