/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.builtin.ProtobufOptionalMixin;
import it.auties.protobuf.model.ProtobufString;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.ContextInfoSpec;
import it.auties.whatsapp.model.message.standard.AudioMessage;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class AudioMessageSpec {
    public static byte[] encode(AudioMessage protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)AudioMessageSpec.sizeOf(protoInputObject));
        AudioMessageSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(AudioMessage protoInputObject, ProtobufOutputStream protoOutputStream) {
        Integer backgroundArgb;
        ByteBuffer waveform1;
        byte[] waveform0;
        Optional<byte[]> waveform;
        ByteBuffer streamingSidecar1;
        byte[] streamingSidecar0;
        Optional<byte[]> streamingSidecar;
        ContextInfo contextInfo0;
        Optional<ContextInfo> contextInfo;
        Long mediaKeyTimestampSeconds0;
        OptionalLong mediaKeyTimestampSeconds;
        ProtobufString mediaDirectPath1;
        String mediaDirectPath0;
        Optional<String> mediaDirectPath;
        ByteBuffer mediaEncryptedSha2561;
        byte[] mediaEncryptedSha2560;
        Optional<byte[]> mediaEncryptedSha256;
        ByteBuffer mediaKey1;
        byte[] mediaKey0;
        Integer duration0;
        OptionalInt duration;
        Long mediaSize0;
        OptionalLong mediaSize;
        ByteBuffer mediaSha2561;
        byte[] mediaSha2560;
        Optional<byte[]> mediaSha256;
        ProtobufString mimetype1;
        String mimetype0;
        Optional<String> mimetype;
        ProtobufString mediaUrl1;
        String mediaUrl0;
        if (protoInputObject == null) {
            return;
        }
        Optional<String> mediaUrl = protoInputObject.mediaUrl();
        if (mediaUrl != null && (mediaUrl0 = (String)ProtobufOptionalMixin.toNullableValue(mediaUrl)) != null && (mediaUrl1 = ProtobufLazyMixin.toValue((String)mediaUrl0)) != null) {
            protoOutputStream.writeString(1, mediaUrl1);
        }
        if ((mimetype = protoInputObject.mimetype()) != null && (mimetype0 = (String)ProtobufOptionalMixin.toNullableValue(mimetype)) != null && (mimetype1 = ProtobufLazyMixin.toValue((String)mimetype0)) != null) {
            protoOutputStream.writeString(2, mimetype1);
        }
        if ((mediaSha256 = protoInputObject.mediaSha256()) != null && (mediaSha2560 = (byte[])ProtobufOptionalMixin.toNullableValue(mediaSha256)) != null && (mediaSha2561 = ProtobufLazyMixin.toValue((byte[])mediaSha2560)) != null) {
            protoOutputStream.writeBytes(3, mediaSha2561);
        }
        if ((mediaSize = protoInputObject.mediaSize()) != null && (mediaSize0 = ProtobufOptionalMixin.toNullableLong((OptionalLong)mediaSize)) != null) {
            protoOutputStream.writeUInt64(4, mediaSize0);
        }
        if ((duration = protoInputObject.duration()) != null && (duration0 = ProtobufOptionalMixin.toNullableInt((OptionalInt)duration)) != null) {
            protoOutputStream.writeUInt32(5, duration0);
        }
        boolean voiceMessage = protoInputObject.voiceMessage();
        protoOutputStream.writeBool(6, Boolean.valueOf(voiceMessage));
        Optional<byte[]> mediaKey = protoInputObject.mediaKey();
        if (mediaKey != null && (mediaKey0 = (byte[])ProtobufOptionalMixin.toNullableValue(mediaKey)) != null && (mediaKey1 = ProtobufLazyMixin.toValue((byte[])mediaKey0)) != null) {
            protoOutputStream.writeBytes(7, mediaKey1);
        }
        if ((mediaEncryptedSha256 = protoInputObject.mediaEncryptedSha256()) != null && (mediaEncryptedSha2560 = (byte[])ProtobufOptionalMixin.toNullableValue(mediaEncryptedSha256)) != null && (mediaEncryptedSha2561 = ProtobufLazyMixin.toValue((byte[])mediaEncryptedSha2560)) != null) {
            protoOutputStream.writeBytes(8, mediaEncryptedSha2561);
        }
        if ((mediaDirectPath = protoInputObject.mediaDirectPath()) != null && (mediaDirectPath0 = (String)ProtobufOptionalMixin.toNullableValue(mediaDirectPath)) != null && (mediaDirectPath1 = ProtobufLazyMixin.toValue((String)mediaDirectPath0)) != null) {
            protoOutputStream.writeString(9, mediaDirectPath1);
        }
        if ((mediaKeyTimestampSeconds = protoInputObject.mediaKeyTimestampSeconds()) != null && (mediaKeyTimestampSeconds0 = ProtobufOptionalMixin.toNullableLong((OptionalLong)mediaKeyTimestampSeconds)) != null) {
            protoOutputStream.writeInt64(10, mediaKeyTimestampSeconds0);
        }
        if ((contextInfo = protoInputObject.contextInfo()) != null && (contextInfo0 = (ContextInfo)ProtobufOptionalMixin.toNullableValue(contextInfo)) != null) {
            protoOutputStream.writeMessage(17, ContextInfoSpec.sizeOf(contextInfo0));
            ContextInfoSpec.encode(contextInfo0, protoOutputStream);
        }
        if ((streamingSidecar = protoInputObject.streamingSidecar()) != null && (streamingSidecar0 = (byte[])ProtobufOptionalMixin.toNullableValue(streamingSidecar)) != null && (streamingSidecar1 = ProtobufLazyMixin.toValue((byte[])streamingSidecar0)) != null) {
            protoOutputStream.writeBytes(18, streamingSidecar1);
        }
        if ((waveform = protoInputObject.waveform()) != null && (waveform0 = (byte[])ProtobufOptionalMixin.toNullableValue(waveform)) != null && (waveform1 = ProtobufLazyMixin.toValue((byte[])waveform0)) != null) {
            protoOutputStream.writeBytes(19, waveform1);
        }
        if ((backgroundArgb = protoInputObject.backgroundArgb()) != null) {
            protoOutputStream.writeFixed32(20, backgroundArgb);
        }
    }

    public static AudioMessage decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return AudioMessageSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static AudioMessage decode(ProtobufInputStream protoInputStream) {
        String mediaUrl = null;
        String mimetype = null;
        byte[] mediaSha256 = null;
        Long mediaSize = null;
        Integer duration = null;
        boolean voiceMessage = false;
        byte[] mediaKey = null;
        byte[] mediaEncryptedSha256 = null;
        String mediaDirectPath = null;
        Long mediaKeyTimestampSeconds = null;
        ContextInfo contextInfo = null;
        byte[] streamingSidecar = null;
        byte[] waveform = null;
        Integer backgroundArgb = null;
        block16: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    mediaUrl = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block16;
                }
                case 2: {
                    mimetype = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block16;
                }
                case 3: {
                    mediaSha256 = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block16;
                }
                case 4: {
                    mediaSize = protoInputStream.readInt64();
                    continue block16;
                }
                case 5: {
                    duration = protoInputStream.readInt32();
                    continue block16;
                }
                case 6: {
                    voiceMessage = protoInputStream.readBool();
                    continue block16;
                }
                case 7: {
                    mediaKey = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block16;
                }
                case 8: {
                    mediaEncryptedSha256 = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block16;
                }
                case 9: {
                    mediaDirectPath = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block16;
                }
                case 10: {
                    mediaKeyTimestampSeconds = protoInputStream.readInt64();
                    continue block16;
                }
                case 17: {
                    contextInfo = ContextInfoSpec.decode(protoInputStream.readLengthDelimited());
                    continue block16;
                }
                case 18: {
                    streamingSidecar = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block16;
                }
                case 19: {
                    waveform = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block16;
                }
                case 20: {
                    backgroundArgb = protoInputStream.readFixed32();
                    continue block16;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new AudioMessage(mediaUrl, mimetype, mediaSha256, mediaSize, duration, voiceMessage, mediaKey, mediaEncryptedSha256, mediaDirectPath, mediaKeyTimestampSeconds, contextInfo, streamingSidecar, waveform, backgroundArgb);
    }

    public static int sizeOf(AudioMessage protoInputObject) {
        Integer backgroundArgb;
        ByteBuffer waveform1;
        byte[] waveform0;
        Optional<byte[]> waveform;
        ByteBuffer streamingSidecar1;
        byte[] streamingSidecar0;
        Optional<byte[]> streamingSidecar;
        ContextInfo contextInfo0;
        Optional<ContextInfo> contextInfo;
        Long mediaKeyTimestampSeconds0;
        OptionalLong mediaKeyTimestampSeconds;
        ProtobufString mediaDirectPath1;
        String mediaDirectPath0;
        Optional<String> mediaDirectPath;
        ByteBuffer mediaEncryptedSha2561;
        byte[] mediaEncryptedSha2560;
        Optional<byte[]> mediaEncryptedSha256;
        ByteBuffer mediaKey1;
        byte[] mediaKey0;
        Integer duration0;
        OptionalInt duration;
        Long mediaSize0;
        OptionalLong mediaSize;
        ByteBuffer mediaSha2561;
        byte[] mediaSha2560;
        Optional<byte[]> mediaSha256;
        ProtobufString mimetype1;
        String mimetype0;
        Optional<String> mimetype;
        ProtobufString mediaUrl1;
        String mediaUrl0;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        Optional<String> mediaUrl = protoInputObject.mediaUrl();
        if (mediaUrl != null && (mediaUrl0 = (String)ProtobufOptionalMixin.toNullableValue(mediaUrl)) != null && (mediaUrl1 = ProtobufLazyMixin.toValue((String)mediaUrl0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)mediaUrl1);
        }
        if ((mimetype = protoInputObject.mimetype()) != null && (mimetype0 = (String)ProtobufOptionalMixin.toNullableValue(mimetype)) != null && (mimetype1 = ProtobufLazyMixin.toValue((String)mimetype0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)mimetype1);
        }
        if ((mediaSha256 = protoInputObject.mediaSha256()) != null && (mediaSha2560 = (byte[])ProtobufOptionalMixin.toNullableValue(mediaSha256)) != null && (mediaSha2561 = ProtobufLazyMixin.toValue((byte[])mediaSha2560)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)mediaSha2561);
        }
        if ((mediaSize = protoInputObject.mediaSize()) != null && (mediaSize0 = ProtobufOptionalMixin.toNullableLong((OptionalLong)mediaSize)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)mediaSize0);
        }
        if ((duration = protoInputObject.duration()) != null && (duration0 = ProtobufOptionalMixin.toNullableInt((OptionalInt)duration)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)5, (int)0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)duration0.intValue());
        }
        boolean voiceMessage = protoInputObject.voiceMessage();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)6, (int)0);
        ++protoOutputSize;
        Optional<byte[]> mediaKey = protoInputObject.mediaKey();
        if (mediaKey != null && (mediaKey0 = (byte[])ProtobufOptionalMixin.toNullableValue(mediaKey)) != null && (mediaKey1 = ProtobufLazyMixin.toValue((byte[])mediaKey0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)7, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)mediaKey1);
        }
        if ((mediaEncryptedSha256 = protoInputObject.mediaEncryptedSha256()) != null && (mediaEncryptedSha2560 = (byte[])ProtobufOptionalMixin.toNullableValue(mediaEncryptedSha256)) != null && (mediaEncryptedSha2561 = ProtobufLazyMixin.toValue((byte[])mediaEncryptedSha2560)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)8, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)mediaEncryptedSha2561);
        }
        if ((mediaDirectPath = protoInputObject.mediaDirectPath()) != null && (mediaDirectPath0 = (String)ProtobufOptionalMixin.toNullableValue(mediaDirectPath)) != null && (mediaDirectPath1 = ProtobufLazyMixin.toValue((String)mediaDirectPath0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)9, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)mediaDirectPath1);
        }
        if ((mediaKeyTimestampSeconds = protoInputObject.mediaKeyTimestampSeconds()) != null && (mediaKeyTimestampSeconds0 = ProtobufOptionalMixin.toNullableLong((OptionalLong)mediaKeyTimestampSeconds)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)10, (int)0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)mediaKeyTimestampSeconds0);
        }
        if ((contextInfo = protoInputObject.contextInfo()) != null && (contextInfo0 = (ContextInfo)ProtobufOptionalMixin.toNullableValue(contextInfo)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)17, (int)2);
            int contextInfoSerializedSize = ContextInfoSpec.sizeOf(contextInfo0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)contextInfoSerializedSize);
            protoOutputSize += contextInfoSerializedSize;
        }
        if ((streamingSidecar = protoInputObject.streamingSidecar()) != null && (streamingSidecar0 = (byte[])ProtobufOptionalMixin.toNullableValue(streamingSidecar)) != null && (streamingSidecar1 = ProtobufLazyMixin.toValue((byte[])streamingSidecar0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)18, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)streamingSidecar1);
        }
        if ((waveform = protoInputObject.waveform()) != null && (waveform0 = (byte[])ProtobufOptionalMixin.toNullableValue(waveform)) != null && (waveform1 = ProtobufLazyMixin.toValue((byte[])waveform0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)19, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)waveform1);
        }
        if ((backgroundArgb = protoInputObject.backgroundArgb()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)20, (int)5);
            protoOutputSize += 4;
        }
        return protoOutputSize;
    }
}

