/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.ChatMessageKeySpec;
import it.auties.whatsapp.model.message.standard.EncryptedReactionMessage;
import java.nio.ByteBuffer;

public class EncryptedReactionMessageSpec {
    public static byte[] encode(EncryptedReactionMessage protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)EncryptedReactionMessageSpec.sizeOf(protoInputObject));
        EncryptedReactionMessageSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(EncryptedReactionMessage protoInputObject, ProtobufOutputStream protoOutputStream) {
        ByteBuffer encIv0;
        byte[] encIv;
        ByteBuffer encPayload0;
        byte[] encPayload;
        if (protoInputObject == null) {
            return;
        }
        ChatMessageKey targetMessageKey = protoInputObject.targetMessageKey();
        if (targetMessageKey != null) {
            protoOutputStream.writeMessage(1, ChatMessageKeySpec.sizeOf(targetMessageKey));
            ChatMessageKeySpec.encode(targetMessageKey, protoOutputStream);
        }
        if ((encPayload = protoInputObject.encPayload()) != null && (encPayload0 = ProtobufLazyMixin.toValue((byte[])encPayload)) != null) {
            protoOutputStream.writeBytes(2, encPayload0);
        }
        if ((encIv = protoInputObject.encIv()) != null && (encIv0 = ProtobufLazyMixin.toValue((byte[])encIv)) != null) {
            protoOutputStream.writeBytes(3, encIv0);
        }
    }

    public static EncryptedReactionMessage decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return EncryptedReactionMessageSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static EncryptedReactionMessage decode(ProtobufInputStream protoInputStream) {
        ChatMessageKey targetMessageKey = null;
        byte[] encPayload = null;
        byte[] encIv = null;
        block5: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    targetMessageKey = ChatMessageKeySpec.decode(protoInputStream.readLengthDelimited());
                    continue block5;
                }
                case 2: {
                    encPayload = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block5;
                }
                case 3: {
                    encIv = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block5;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new EncryptedReactionMessage(targetMessageKey, encPayload, encIv);
    }

    public static int sizeOf(EncryptedReactionMessage protoInputObject) {
        ByteBuffer encIv0;
        byte[] encIv;
        ByteBuffer encPayload0;
        byte[] encPayload;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        ChatMessageKey targetMessageKey = protoInputObject.targetMessageKey();
        if (targetMessageKey != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            int targetMessageKeySerializedSize = ChatMessageKeySpec.sizeOf(targetMessageKey);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)targetMessageKeySerializedSize);
            protoOutputSize += targetMessageKeySerializedSize;
        }
        if ((encPayload = protoInputObject.encPayload()) != null && (encPayload0 = ProtobufLazyMixin.toValue((byte[])encPayload)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)encPayload0);
        }
        if ((encIv = protoInputObject.encIv()) != null && (encIv0 = ProtobufLazyMixin.toValue((byte[])encIv)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)encIv0);
        }
        return protoOutputSize;
    }
}

