/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.builtin.ProtobufOptionalMixin;
import it.auties.protobuf.model.ProtobufString;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.ContextInfoSpec;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.message.standard.GroupInviteMessage;
import it.auties.whatsapp.model.message.standard.GroupInviteMessageTypeSpec;
import java.nio.ByteBuffer;
import java.util.Optional;

public class GroupInviteMessageSpec {
    public static byte[] encode(GroupInviteMessage protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)GroupInviteMessageSpec.sizeOf(protoInputObject));
        GroupInviteMessageSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(GroupInviteMessage protoInputObject, ProtobufOutputStream protoOutputStream) {
        GroupInviteMessage.Type groupType;
        ContextInfo contextInfo0;
        Optional<ContextInfo> contextInfo;
        ProtobufString caption1;
        String caption0;
        Optional<String> caption;
        ByteBuffer thumbnail1;
        byte[] thumbnail0;
        Optional<byte[]> thumbnail;
        ProtobufString groupName0;
        ProtobufString code0;
        String code;
        ProtobufString group1;
        String group0;
        if (protoInputObject == null) {
            return;
        }
        Jid group = protoInputObject.group();
        if (group != null && (group0 = group.toString()) != null && (group1 = ProtobufLazyMixin.toValue((String)group0)) != null) {
            protoOutputStream.writeString(1, group1);
        }
        if ((code = protoInputObject.code()) != null && (code0 = ProtobufLazyMixin.toValue((String)code)) != null) {
            protoOutputStream.writeString(2, code0);
        }
        long expirationSeconds = protoInputObject.expirationSeconds();
        protoOutputStream.writeUInt64(3, Long.valueOf(expirationSeconds));
        String groupName = protoInputObject.groupName();
        if (groupName != null && (groupName0 = ProtobufLazyMixin.toValue((String)groupName)) != null) {
            protoOutputStream.writeString(4, groupName0);
        }
        if ((thumbnail = protoInputObject.thumbnail()) != null && (thumbnail0 = (byte[])ProtobufOptionalMixin.toNullableValue(thumbnail)) != null && (thumbnail1 = ProtobufLazyMixin.toValue((byte[])thumbnail0)) != null) {
            protoOutputStream.writeBytes(5, thumbnail1);
        }
        if ((caption = protoInputObject.caption()) != null && (caption0 = (String)ProtobufOptionalMixin.toNullableValue(caption)) != null && (caption1 = ProtobufLazyMixin.toValue((String)caption0)) != null) {
            protoOutputStream.writeString(6, caption1);
        }
        if ((contextInfo = protoInputObject.contextInfo()) != null && (contextInfo0 = (ContextInfo)ProtobufOptionalMixin.toNullableValue(contextInfo)) != null) {
            protoOutputStream.writeMessage(7, ContextInfoSpec.sizeOf(contextInfo0));
            ContextInfoSpec.encode(contextInfo0, protoOutputStream);
        }
        if ((groupType = protoInputObject.groupType()) != null) {
            Integer groupType0 = GroupInviteMessageTypeSpec.encode(groupType);
            protoOutputStream.writeInt32(8, groupType0);
        }
    }

    public static GroupInviteMessage decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return GroupInviteMessageSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static GroupInviteMessage decode(ProtobufInputStream protoInputStream) {
        Jid group = null;
        String code = null;
        long expirationSeconds = 0L;
        String groupName = null;
        byte[] thumbnail = null;
        String caption = null;
        ContextInfo contextInfo = null;
        GroupInviteMessage.Type groupType = null;
        block10: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    group = Jid.of(ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString()));
                    continue block10;
                }
                case 2: {
                    code = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block10;
                }
                case 3: {
                    expirationSeconds = protoInputStream.readInt64();
                    continue block10;
                }
                case 4: {
                    groupName = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block10;
                }
                case 5: {
                    thumbnail = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block10;
                }
                case 6: {
                    caption = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block10;
                }
                case 7: {
                    contextInfo = ContextInfoSpec.decode(protoInputStream.readLengthDelimited());
                    continue block10;
                }
                case 8: {
                    groupType = GroupInviteMessageTypeSpec.decode(protoInputStream.readInt32());
                    continue block10;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new GroupInviteMessage(group, code, expirationSeconds, groupName, thumbnail, caption, contextInfo, groupType);
    }

    public static int sizeOf(GroupInviteMessage protoInputObject) {
        GroupInviteMessage.Type groupType;
        ContextInfo contextInfo0;
        Optional<ContextInfo> contextInfo;
        ProtobufString caption1;
        String caption0;
        Optional<String> caption;
        ByteBuffer thumbnail1;
        byte[] thumbnail0;
        Optional<byte[]> thumbnail;
        ProtobufString groupName0;
        ProtobufString code0;
        String code;
        ProtobufString group1;
        String group0;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        Jid group = protoInputObject.group();
        if (group != null && (group0 = group.toString()) != null && (group1 = ProtobufLazyMixin.toValue((String)group0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)group1);
        }
        if ((code = protoInputObject.code()) != null && (code0 = ProtobufLazyMixin.toValue((String)code)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)code0);
        }
        long expirationSeconds = protoInputObject.expirationSeconds();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)expirationSeconds);
        String groupName = protoInputObject.groupName();
        if (groupName != null && (groupName0 = ProtobufLazyMixin.toValue((String)groupName)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)groupName0);
        }
        if ((thumbnail = protoInputObject.thumbnail()) != null && (thumbnail0 = (byte[])ProtobufOptionalMixin.toNullableValue(thumbnail)) != null && (thumbnail1 = ProtobufLazyMixin.toValue((byte[])thumbnail0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)5, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)thumbnail1);
        }
        if ((caption = protoInputObject.caption()) != null && (caption0 = (String)ProtobufOptionalMixin.toNullableValue(caption)) != null && (caption1 = ProtobufLazyMixin.toValue((String)caption0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)6, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)caption1);
        }
        if ((contextInfo = protoInputObject.contextInfo()) != null && (contextInfo0 = (ContextInfo)ProtobufOptionalMixin.toNullableValue(contextInfo)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)7, (int)2);
            int contextInfoSerializedSize = ContextInfoSpec.sizeOf(contextInfo0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)contextInfoSerializedSize);
            protoOutputSize += contextInfoSerializedSize;
        }
        if ((groupType = protoInputObject.groupType()) != null) {
            Integer groupType0 = GroupInviteMessageTypeSpec.encode(groupType);
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)8, (int)2);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)groupType0.intValue());
        }
        return protoOutputSize;
    }
}

