/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.ChatMessageKeySpec;
import it.auties.whatsapp.model.message.model.KeepInChatType;
import it.auties.whatsapp.model.message.model.KeepInChatTypeSpec;
import it.auties.whatsapp.model.message.standard.KeepInChatMessage;

public class KeepInChatMessageSpec {
    public static byte[] encode(KeepInChatMessage protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)KeepInChatMessageSpec.sizeOf(protoInputObject));
        KeepInChatMessageSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(KeepInChatMessage protoInputObject, ProtobufOutputStream protoOutputStream) {
        KeepInChatType keepType;
        if (protoInputObject == null) {
            return;
        }
        ChatMessageKey key = protoInputObject.key();
        if (key != null) {
            protoOutputStream.writeMessage(1, ChatMessageKeySpec.sizeOf(key));
            ChatMessageKeySpec.encode(key, protoOutputStream);
        }
        if ((keepType = protoInputObject.keepType()) != null) {
            Integer keepType0 = KeepInChatTypeSpec.encode(keepType);
            protoOutputStream.writeInt32(2, keepType0);
        }
        long timestampMilliseconds = protoInputObject.timestampMilliseconds();
        protoOutputStream.writeInt64(3, Long.valueOf(timestampMilliseconds));
    }

    public static KeepInChatMessage decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return KeepInChatMessageSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static KeepInChatMessage decode(ProtobufInputStream protoInputStream) {
        ChatMessageKey key = null;
        KeepInChatType keepType = null;
        long timestampMilliseconds = 0L;
        block5: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    key = ChatMessageKeySpec.decode(protoInputStream.readLengthDelimited());
                    continue block5;
                }
                case 2: {
                    keepType = KeepInChatTypeSpec.decode(protoInputStream.readInt32());
                    continue block5;
                }
                case 3: {
                    timestampMilliseconds = protoInputStream.readInt64();
                    continue block5;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new KeepInChatMessage(key, keepType, timestampMilliseconds);
    }

    public static int sizeOf(KeepInChatMessage protoInputObject) {
        KeepInChatType keepType;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        ChatMessageKey key = protoInputObject.key();
        if (key != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            int keySerializedSize = ChatMessageKeySpec.sizeOf(key);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)keySerializedSize);
            protoOutputSize += keySerializedSize;
        }
        if ((keepType = protoInputObject.keepType()) != null) {
            Integer keepType0 = KeepInChatTypeSpec.encode(keepType);
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)keepType0.intValue());
        }
        long timestampMilliseconds = protoInputObject.timestampMilliseconds();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)0);
        return protoOutputSize += ProtobufOutputStream.getVarIntSize((long)timestampMilliseconds);
    }
}

