/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.builtin.ProtobufOptionalMixin;
import it.auties.protobuf.model.ProtobufString;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.ContextInfoSpec;
import it.auties.whatsapp.model.message.standard.LiveLocationMessage;
import java.nio.ByteBuffer;
import java.util.Optional;

public class LiveLocationMessageSpec {
    public static byte[] encode(LiveLocationMessage protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)LiveLocationMessageSpec.sizeOf(protoInputObject));
        LiveLocationMessageSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(LiveLocationMessage protoInputObject, ProtobufOutputStream protoOutputStream) {
        ContextInfo contextInfo0;
        Optional<ContextInfo> contextInfo;
        ByteBuffer thumbnail1;
        byte[] thumbnail0;
        ProtobufString caption1;
        String caption0;
        if (protoInputObject == null) {
            return;
        }
        double latitude = protoInputObject.latitude();
        protoOutputStream.writeDouble(1, Double.valueOf(latitude));
        double longitude = protoInputObject.longitude();
        protoOutputStream.writeDouble(2, Double.valueOf(longitude));
        int accuracy = protoInputObject.accuracy();
        protoOutputStream.writeUInt32(3, Integer.valueOf(accuracy));
        float speed = protoInputObject.speed();
        protoOutputStream.writeFloat(4, Float.valueOf(speed));
        int magneticNorthOffset = protoInputObject.magneticNorthOffset();
        protoOutputStream.writeUInt32(5, Integer.valueOf(magneticNorthOffset));
        Optional<String> caption = protoInputObject.caption();
        if (caption != null && (caption0 = (String)ProtobufOptionalMixin.toNullableValue(caption)) != null && (caption1 = ProtobufLazyMixin.toValue((String)caption0)) != null) {
            protoOutputStream.writeString(6, caption1);
        }
        long sequenceNumber = protoInputObject.sequenceNumber();
        protoOutputStream.writeUInt64(7, Long.valueOf(sequenceNumber));
        int timeOffset = protoInputObject.timeOffset();
        protoOutputStream.writeUInt32(8, Integer.valueOf(timeOffset));
        Optional<byte[]> thumbnail = protoInputObject.thumbnail();
        if (thumbnail != null && (thumbnail0 = (byte[])ProtobufOptionalMixin.toNullableValue(thumbnail)) != null && (thumbnail1 = ProtobufLazyMixin.toValue((byte[])thumbnail0)) != null) {
            protoOutputStream.writeBytes(16, thumbnail1);
        }
        if ((contextInfo = protoInputObject.contextInfo()) != null && (contextInfo0 = (ContextInfo)ProtobufOptionalMixin.toNullableValue(contextInfo)) != null) {
            protoOutputStream.writeMessage(17, ContextInfoSpec.sizeOf(contextInfo0));
            ContextInfoSpec.encode(contextInfo0, protoOutputStream);
        }
    }

    public static LiveLocationMessage decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return LiveLocationMessageSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static LiveLocationMessage decode(ProtobufInputStream protoInputStream) {
        double latitude = 0.0;
        double longitude = 0.0;
        int accuracy = 0;
        float speed = 0.0f;
        int magneticNorthOffset = 0;
        String caption = null;
        long sequenceNumber = 0L;
        int timeOffset = 0;
        byte[] thumbnail = null;
        ContextInfo contextInfo = null;
        block12: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    latitude = protoInputStream.readDouble();
                    continue block12;
                }
                case 2: {
                    longitude = protoInputStream.readDouble();
                    continue block12;
                }
                case 3: {
                    accuracy = protoInputStream.readInt32();
                    continue block12;
                }
                case 4: {
                    speed = protoInputStream.readFloat();
                    continue block12;
                }
                case 5: {
                    magneticNorthOffset = protoInputStream.readInt32();
                    continue block12;
                }
                case 6: {
                    caption = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block12;
                }
                case 7: {
                    sequenceNumber = protoInputStream.readInt64();
                    continue block12;
                }
                case 8: {
                    timeOffset = protoInputStream.readInt32();
                    continue block12;
                }
                case 16: {
                    thumbnail = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block12;
                }
                case 17: {
                    contextInfo = ContextInfoSpec.decode(protoInputStream.readLengthDelimited());
                    continue block12;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new LiveLocationMessage(latitude, longitude, accuracy, speed, magneticNorthOffset, caption, sequenceNumber, timeOffset, thumbnail, contextInfo);
    }

    public static int sizeOf(LiveLocationMessage protoInputObject) {
        ContextInfo contextInfo0;
        Optional<ContextInfo> contextInfo;
        ByteBuffer thumbnail1;
        byte[] thumbnail0;
        ProtobufString caption1;
        String caption0;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        double latitude = protoInputObject.latitude();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)1);
        protoOutputSize += 8;
        double longitude = protoInputObject.longitude();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)1);
        protoOutputSize += 8;
        int accuracy = protoInputObject.accuracy();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)accuracy);
        float speed = protoInputObject.speed();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)5);
        protoOutputSize += 4;
        int magneticNorthOffset = protoInputObject.magneticNorthOffset();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)5, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)magneticNorthOffset);
        Optional<String> caption = protoInputObject.caption();
        if (caption != null && (caption0 = (String)ProtobufOptionalMixin.toNullableValue(caption)) != null && (caption1 = ProtobufLazyMixin.toValue((String)caption0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)6, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)caption1);
        }
        long sequenceNumber = protoInputObject.sequenceNumber();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)7, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)sequenceNumber);
        int timeOffset = protoInputObject.timeOffset();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)8, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)timeOffset);
        Optional<byte[]> thumbnail = protoInputObject.thumbnail();
        if (thumbnail != null && (thumbnail0 = (byte[])ProtobufOptionalMixin.toNullableValue(thumbnail)) != null && (thumbnail1 = ProtobufLazyMixin.toValue((byte[])thumbnail0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)16, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)thumbnail1);
        }
        if ((contextInfo = protoInputObject.contextInfo()) != null && (contextInfo0 = (ContextInfo)ProtobufOptionalMixin.toNullableValue(contextInfo)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)17, (int)2);
            int contextInfoSerializedSize = ContextInfoSpec.sizeOf(contextInfo0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)contextInfoSerializedSize);
            protoOutputSize += contextInfoSerializedSize;
        }
        return protoOutputSize;
    }
}

