/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.builtin.ProtobufOptionalMixin;
import it.auties.protobuf.model.ProtobufString;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.ContextInfoSpec;
import it.auties.whatsapp.model.message.standard.LocationMessage;
import java.nio.ByteBuffer;
import java.util.Optional;

public class LocationMessageSpec {
    public static byte[] encode(LocationMessage protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)LocationMessageSpec.sizeOf(protoInputObject));
        LocationMessageSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(LocationMessage protoInputObject, ProtobufOutputStream protoOutputStream) {
        ContextInfo contextInfo0;
        Optional<ContextInfo> contextInfo;
        ByteBuffer thumbnail1;
        byte[] thumbnail0;
        Optional<byte[]> thumbnail;
        ProtobufString caption1;
        String caption0;
        ProtobufString url1;
        String url0;
        Optional<String> url;
        ProtobufString address1;
        String address0;
        Optional<String> address;
        ProtobufString name1;
        String name0;
        if (protoInputObject == null) {
            return;
        }
        double latitude = protoInputObject.latitude();
        protoOutputStream.writeDouble(1, Double.valueOf(latitude));
        double longitude = protoInputObject.longitude();
        protoOutputStream.writeDouble(2, Double.valueOf(longitude));
        Optional<String> name = protoInputObject.name();
        if (name != null && (name0 = (String)ProtobufOptionalMixin.toNullableValue(name)) != null && (name1 = ProtobufLazyMixin.toValue((String)name0)) != null) {
            protoOutputStream.writeString(3, name1);
        }
        if ((address = protoInputObject.address()) != null && (address0 = (String)ProtobufOptionalMixin.toNullableValue(address)) != null && (address1 = ProtobufLazyMixin.toValue((String)address0)) != null) {
            protoOutputStream.writeString(4, address1);
        }
        if ((url = protoInputObject.url()) != null && (url0 = (String)ProtobufOptionalMixin.toNullableValue(url)) != null && (url1 = ProtobufLazyMixin.toValue((String)url0)) != null) {
            protoOutputStream.writeString(5, url1);
        }
        boolean live = protoInputObject.live();
        protoOutputStream.writeBool(6, Boolean.valueOf(live));
        int accuracy = protoInputObject.accuracy();
        protoOutputStream.writeUInt32(7, Integer.valueOf(accuracy));
        float speed = protoInputObject.speed();
        protoOutputStream.writeFloat(8, Float.valueOf(speed));
        int magneticNorthOffset = protoInputObject.magneticNorthOffset();
        protoOutputStream.writeUInt32(9, Integer.valueOf(magneticNorthOffset));
        Optional<String> caption = protoInputObject.caption();
        if (caption != null && (caption0 = (String)ProtobufOptionalMixin.toNullableValue(caption)) != null && (caption1 = ProtobufLazyMixin.toValue((String)caption0)) != null) {
            protoOutputStream.writeString(11, caption1);
        }
        if ((thumbnail = protoInputObject.thumbnail()) != null && (thumbnail0 = (byte[])ProtobufOptionalMixin.toNullableValue(thumbnail)) != null && (thumbnail1 = ProtobufLazyMixin.toValue((byte[])thumbnail0)) != null) {
            protoOutputStream.writeBytes(16, thumbnail1);
        }
        if ((contextInfo = protoInputObject.contextInfo()) != null && (contextInfo0 = (ContextInfo)ProtobufOptionalMixin.toNullableValue(contextInfo)) != null) {
            protoOutputStream.writeMessage(17, ContextInfoSpec.sizeOf(contextInfo0));
            ContextInfoSpec.encode(contextInfo0, protoOutputStream);
        }
    }

    public static LocationMessage decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return LocationMessageSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static LocationMessage decode(ProtobufInputStream protoInputStream) {
        double latitude = 0.0;
        double longitude = 0.0;
        String name = null;
        String address = null;
        String url = null;
        boolean live = false;
        int accuracy = 0;
        float speed = 0.0f;
        int magneticNorthOffset = 0;
        String caption = null;
        byte[] thumbnail = null;
        ContextInfo contextInfo = null;
        block14: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    latitude = protoInputStream.readDouble();
                    continue block14;
                }
                case 2: {
                    longitude = protoInputStream.readDouble();
                    continue block14;
                }
                case 3: {
                    name = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block14;
                }
                case 4: {
                    address = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block14;
                }
                case 5: {
                    url = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block14;
                }
                case 6: {
                    live = protoInputStream.readBool();
                    continue block14;
                }
                case 7: {
                    accuracy = protoInputStream.readInt32();
                    continue block14;
                }
                case 8: {
                    speed = protoInputStream.readFloat();
                    continue block14;
                }
                case 9: {
                    magneticNorthOffset = protoInputStream.readInt32();
                    continue block14;
                }
                case 11: {
                    caption = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block14;
                }
                case 16: {
                    thumbnail = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block14;
                }
                case 17: {
                    contextInfo = ContextInfoSpec.decode(protoInputStream.readLengthDelimited());
                    continue block14;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new LocationMessage(latitude, longitude, name, address, url, live, accuracy, speed, magneticNorthOffset, caption, thumbnail, contextInfo);
    }

    public static int sizeOf(LocationMessage protoInputObject) {
        ContextInfo contextInfo0;
        Optional<ContextInfo> contextInfo;
        ByteBuffer thumbnail1;
        byte[] thumbnail0;
        Optional<byte[]> thumbnail;
        ProtobufString caption1;
        String caption0;
        ProtobufString url1;
        String url0;
        Optional<String> url;
        ProtobufString address1;
        String address0;
        Optional<String> address;
        ProtobufString name1;
        String name0;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        double latitude = protoInputObject.latitude();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)1);
        protoOutputSize += 8;
        double longitude = protoInputObject.longitude();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)1);
        protoOutputSize += 8;
        Optional<String> name = protoInputObject.name();
        if (name != null && (name0 = (String)ProtobufOptionalMixin.toNullableValue(name)) != null && (name1 = ProtobufLazyMixin.toValue((String)name0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)name1);
        }
        if ((address = protoInputObject.address()) != null && (address0 = (String)ProtobufOptionalMixin.toNullableValue(address)) != null && (address1 = ProtobufLazyMixin.toValue((String)address0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)address1);
        }
        if ((url = protoInputObject.url()) != null && (url0 = (String)ProtobufOptionalMixin.toNullableValue(url)) != null && (url1 = ProtobufLazyMixin.toValue((String)url0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)5, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)url1);
        }
        boolean live = protoInputObject.live();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)6, (int)0);
        ++protoOutputSize;
        int accuracy = protoInputObject.accuracy();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)7, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)accuracy);
        float speed = protoInputObject.speed();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)8, (int)5);
        protoOutputSize += 4;
        int magneticNorthOffset = protoInputObject.magneticNorthOffset();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)9, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)magneticNorthOffset);
        Optional<String> caption = protoInputObject.caption();
        if (caption != null && (caption0 = (String)ProtobufOptionalMixin.toNullableValue(caption)) != null && (caption1 = ProtobufLazyMixin.toValue((String)caption0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)11, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)caption1);
        }
        if ((thumbnail = protoInputObject.thumbnail()) != null && (thumbnail0 = (byte[])ProtobufOptionalMixin.toNullableValue(thumbnail)) != null && (thumbnail1 = ProtobufLazyMixin.toValue((byte[])thumbnail0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)16, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)thumbnail1);
        }
        if ((contextInfo = protoInputObject.contextInfo()) != null && (contextInfo0 = (ContextInfo)ProtobufOptionalMixin.toNullableValue(contextInfo)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)17, (int)2);
            int contextInfoSerializedSize = ContextInfoSpec.sizeOf(contextInfo0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)contextInfoSerializedSize);
            protoOutputSize += contextInfoSerializedSize;
        }
        return protoOutputSize;
    }
}

