/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.builtin.ProtobufOptionalMixin;
import it.auties.protobuf.model.ProtobufString;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.info.ContextInfoSpec;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.message.standard.ProductMessage;
import it.auties.whatsapp.model.product.Product;
import it.auties.whatsapp.model.product.ProductCatalog;
import it.auties.whatsapp.model.product.ProductCatalogSpec;
import it.auties.whatsapp.model.product.ProductSpec;
import java.util.Optional;

public class ProductMessageSpec {
    public static byte[] encode(ProductMessage protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)ProductMessageSpec.sizeOf(protoInputObject));
        ProductMessageSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(ProductMessage protoInputObject, ProtobufOutputStream protoOutputStream) {
        ContextInfo contextInfo0;
        Optional<ContextInfo> contextInfo;
        ProtobufString footer1;
        String footer0;
        Optional<String> footer;
        ProtobufString body1;
        String body0;
        Optional<String> body;
        ProductCatalog catalog;
        ProtobufString businessOwnerJid1;
        String businessOwnerJid0;
        Jid businessOwnerJid;
        if (protoInputObject == null) {
            return;
        }
        Product product = protoInputObject.product();
        if (product != null) {
            protoOutputStream.writeMessage(1, ProductSpec.sizeOf(product));
            ProductSpec.encode(product, protoOutputStream);
        }
        if ((businessOwnerJid = protoInputObject.businessOwnerJid()) != null && (businessOwnerJid0 = businessOwnerJid.toString()) != null && (businessOwnerJid1 = ProtobufLazyMixin.toValue((String)businessOwnerJid0)) != null) {
            protoOutputStream.writeString(2, businessOwnerJid1);
        }
        if ((catalog = protoInputObject.catalog()) != null) {
            protoOutputStream.writeMessage(4, ProductCatalogSpec.sizeOf(catalog));
            ProductCatalogSpec.encode(catalog, protoOutputStream);
        }
        if ((body = protoInputObject.body()) != null && (body0 = (String)ProtobufOptionalMixin.toNullableValue(body)) != null && (body1 = ProtobufLazyMixin.toValue((String)body0)) != null) {
            protoOutputStream.writeString(5, body1);
        }
        if ((footer = protoInputObject.footer()) != null && (footer0 = (String)ProtobufOptionalMixin.toNullableValue(footer)) != null && (footer1 = ProtobufLazyMixin.toValue((String)footer0)) != null) {
            protoOutputStream.writeString(6, footer1);
        }
        if ((contextInfo = protoInputObject.contextInfo()) != null && (contextInfo0 = (ContextInfo)ProtobufOptionalMixin.toNullableValue(contextInfo)) != null) {
            protoOutputStream.writeMessage(17, ContextInfoSpec.sizeOf(contextInfo0));
            ContextInfoSpec.encode(contextInfo0, protoOutputStream);
        }
    }

    public static ProductMessage decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return ProductMessageSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static ProductMessage decode(ProtobufInputStream protoInputStream) {
        Product product = null;
        Jid businessOwnerJid = null;
        ProductCatalog catalog = null;
        String body = null;
        String footer = null;
        ContextInfo contextInfo = null;
        block8: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    product = ProductSpec.decode(protoInputStream.readLengthDelimited());
                    continue block8;
                }
                case 2: {
                    businessOwnerJid = Jid.of(ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString()));
                    continue block8;
                }
                case 4: {
                    catalog = ProductCatalogSpec.decode(protoInputStream.readLengthDelimited());
                    continue block8;
                }
                case 5: {
                    body = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block8;
                }
                case 6: {
                    footer = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block8;
                }
                case 17: {
                    contextInfo = ContextInfoSpec.decode(protoInputStream.readLengthDelimited());
                    continue block8;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new ProductMessage(product, businessOwnerJid, catalog, body, footer, contextInfo);
    }

    public static int sizeOf(ProductMessage protoInputObject) {
        ContextInfo contextInfo0;
        Optional<ContextInfo> contextInfo;
        ProtobufString footer1;
        String footer0;
        Optional<String> footer;
        ProtobufString body1;
        String body0;
        Optional<String> body;
        ProductCatalog catalog;
        ProtobufString businessOwnerJid1;
        String businessOwnerJid0;
        Jid businessOwnerJid;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        Product product = protoInputObject.product();
        if (product != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            int productSerializedSize = ProductSpec.sizeOf(product);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)productSerializedSize);
            protoOutputSize += productSerializedSize;
        }
        if ((businessOwnerJid = protoInputObject.businessOwnerJid()) != null && (businessOwnerJid0 = businessOwnerJid.toString()) != null && (businessOwnerJid1 = ProtobufLazyMixin.toValue((String)businessOwnerJid0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)businessOwnerJid1);
        }
        if ((catalog = protoInputObject.catalog()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)2);
            int catalogSerializedSize = ProductCatalogSpec.sizeOf(catalog);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)catalogSerializedSize);
            protoOutputSize += catalogSerializedSize;
        }
        if ((body = protoInputObject.body()) != null && (body0 = (String)ProtobufOptionalMixin.toNullableValue(body)) != null && (body1 = ProtobufLazyMixin.toValue((String)body0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)5, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)body1);
        }
        if ((footer = protoInputObject.footer()) != null && (footer0 = (String)ProtobufOptionalMixin.toNullableValue(footer)) != null && (footer1 = ProtobufLazyMixin.toValue((String)footer0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)6, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)footer1);
        }
        if ((contextInfo = protoInputObject.contextInfo()) != null && (contextInfo0 = (ContextInfo)ProtobufOptionalMixin.toNullableValue(contextInfo)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)17, (int)2);
            int contextInfoSerializedSize = ContextInfoSpec.sizeOf(contextInfo0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)contextInfoSerializedSize);
            protoOutputSize += contextInfoSerializedSize;
        }
        return protoOutputSize;
    }
}

