/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.mobile;

import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.util.Validate;
import java.util.Base64;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record SixPartsKeys(PhoneNumber phoneNumber, SignalKeyPair noiseKeyPair, SignalKeyPair identityKeyPair, byte[] identityId) {
    public static SixPartsKeys of(String sixParts) {
        Objects.requireNonNull(sixParts, "Invalid six parts");
        String[] parts = sixParts.replaceAll(" ", "").replaceAll("\n", "").split(",", 6);
        Validate.isTrue(parts.length == 6, "Invalid format", new Object[0]);
        PhoneNumber phoneNumber = PhoneNumber.of(parts[0]);
        byte[] noisePublicKey = Base64.getDecoder().decode(parts[1]);
        byte[] noisePrivateKey = Base64.getDecoder().decode(parts[2]);
        byte[] identityPublicKey = Base64.getDecoder().decode(parts[3]);
        byte[] identityPrivateKey = Base64.getDecoder().decode(parts[4]);
        byte[] identityId = Base64.getDecoder().decode(parts[5]);
        SignalKeyPair noiseKeyPair = new SignalKeyPair(noisePublicKey, noisePrivateKey);
        SignalKeyPair identityKeyPair = new SignalKeyPair(identityPublicKey, identityPrivateKey);
        return new SixPartsKeys(phoneNumber, noiseKeyPair, identityKeyPair, identityId);
    }

    @Override
    public String toString() {
        String cryptographicKeys = Stream.of(this.noiseKeyPair.publicKey(), this.noiseKeyPair.privateKey(), this.identityKeyPair.publicKey(), this.identityKeyPair.privateKey(), this.identityId()).map(Base64.getEncoder()::encodeToString).collect(Collectors.joining(","));
        return String.valueOf(this.phoneNumber) + "," + cryptographicKeys;
    }
}

