/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.mobile;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;

public enum VerificationCodeMethod {
    NONE("", false),
    SMS("sms", true),
    SMS_NO_FALLBACK("sms", false),
    CALL("voice", true),
    CALL_NO_FALLBACK("voice", false),
    WHATSAPP("wa_old", false);

    private final String data;
    private final boolean fallback;

    private VerificationCodeMethod(String data, boolean fallback) {
        this.data = data;
        this.fallback = fallback;
    }

    @JsonCreator
    public static VerificationCodeMethod of(String type) {
        return Arrays.stream(VerificationCodeMethod.values()).filter(entry -> entry.data().equals(type)).findFirst().orElse(NONE);
    }

    public String data() {
        return this.data;
    }

    public boolean hasFallback() {
        return this.fallback;
    }
}

