/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.newsletter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.auties.protobuf.annotation.ProtobufMessage;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.info.NewsletterMessageInfo;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.jid.JidProvider;
import it.auties.whatsapp.model.newsletter.NewsletterMetadata;
import it.auties.whatsapp.model.newsletter.NewsletterState;
import it.auties.whatsapp.model.newsletter.NewsletterViewerMetadata;
import it.auties.whatsapp.util.ConcurrentLinkedSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

@ProtobufMessage
public final class Newsletter
implements JidProvider {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    private final Jid jid;
    @ProtobufProperty(index=2, type=ProtobufType.MESSAGE)
    private NewsletterState state;
    @ProtobufProperty(index=3, type=ProtobufType.MESSAGE)
    private NewsletterMetadata metadata;
    @ProtobufProperty(index=4, type=ProtobufType.MESSAGE)
    private final NewsletterViewerMetadata viewerMetadata;
    @ProtobufProperty(index=5, type=ProtobufType.MESSAGE)
    private final ConcurrentLinkedSet<NewsletterMessageInfo> messages;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    Newsletter(@JsonProperty(value="id") Jid jid, @JsonProperty(value="state") NewsletterState state, @JsonProperty(value="thread_metadata") NewsletterMetadata metadata, @JsonProperty(value="viewer_metadata") NewsletterViewerMetadata viewerMetadata, @JsonProperty(value="messages") ConcurrentLinkedSet<NewsletterMessageInfo> messages) {
        this.jid = jid;
        this.state = state;
        this.metadata = metadata;
        this.viewerMetadata = viewerMetadata;
        this.messages = Objects.requireNonNullElseGet(messages, ConcurrentLinkedSet::new);
    }

    public Newsletter(Jid jid, NewsletterState state, NewsletterMetadata metadata, NewsletterViewerMetadata viewerMetadata) {
        this.jid = jid;
        this.state = state;
        this.metadata = metadata;
        this.viewerMetadata = viewerMetadata;
        this.messages = new ConcurrentLinkedSet();
    }

    public void addMessage(NewsletterMessageInfo message) {
        this.messages.add(message);
    }

    public boolean removeMessage(NewsletterMessageInfo message) {
        return this.messages.remove(message);
    }

    public void addMessages(Collection<NewsletterMessageInfo> messages) {
        this.messages.addAll(messages);
    }

    public Collection<NewsletterMessageInfo> messages() {
        return Collections.unmodifiableCollection(this.messages);
    }

    public Optional<NewsletterMessageInfo> oldestMessage() {
        return Optional.ofNullable(this.messages.peekFirst());
    }

    public Optional<NewsletterMessageInfo> newestMessage() {
        return Optional.ofNullable(this.messages.peekLast());
    }

    @Override
    public Jid toJid() {
        return this.jid;
    }

    public Jid jid() {
        return this.jid;
    }

    public Optional<NewsletterState> state() {
        return Optional.ofNullable(this.state);
    }

    public Newsletter setState(NewsletterState state) {
        this.state = state;
        return this;
    }

    public Newsletter setMetadata(NewsletterMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public NewsletterMetadata metadata() {
        return this.metadata;
    }

    public Optional<NewsletterViewerMetadata> viewerMetadata() {
        return Optional.ofNullable(this.viewerMetadata);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof Newsletter)) return false;
        Newsletter that = (Newsletter)o;
        if (!Objects.equals(this.jid, that.jid)) return false;
        if (!Objects.equals(this.state, that.state)) return false;
        if (!Objects.equals(this.metadata, that.metadata)) return false;
        if (!Objects.equals(this.viewerMetadata, that.viewerMetadata)) return false;
        if (!Objects.equals(this.messages, that.messages)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.jid, this.state, this.metadata, this.viewerMetadata, this.messages);
    }

    public String toString() {
        return "Newsletter{jid=" + String.valueOf(this.jid) + ", state=" + String.valueOf(this.state) + ", metadata=" + String.valueOf(this.metadata) + ", viewerMetadata=" + String.valueOf(this.viewerMetadata) + ", messages=" + String.valueOf(this.messages) + "}";
    }
}

