/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.node;

import it.auties.whatsapp.model.node.Attributes;
import it.auties.whatsapp.util.Json;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record Node(String description, Attributes attributes, Object content) {
    public static Node of(String description) {
        return new Node(description, Attributes.of(new Map.Entry[0]), null);
    }

    public static Node of(String description, Object contentOrAttributes) {
        if (contentOrAttributes instanceof Attributes) {
            Attributes attributes = (Attributes)contentOrAttributes;
            return new Node(description, attributes, null);
        }
        if (contentOrAttributes instanceof Map) {
            Map attributes = (Map)contentOrAttributes;
            try {
                return new Node(description, Node.getAttributesOrThrow(attributes), null);
            }
            catch (ClassCastException exception) {
                throw new IllegalArgumentException("Unexpected attributes type: " + contentOrAttributes.getClass().getName(), exception);
            }
        }
        if (contentOrAttributes instanceof List) {
            List list = (List)contentOrAttributes;
            try {
                return new Node(description, Attributes.of(new Map.Entry[0]), Node.getNodesOrThrow(list));
            }
            catch (ClassCastException exception) {
                throw new IllegalArgumentException("Unexpected attributes type: " + contentOrAttributes.getClass().getName(), exception);
            }
        }
        if (contentOrAttributes instanceof Node) {
            Node node = (Node)contentOrAttributes;
            return new Node(description, Attributes.of(new Map.Entry[0]), List.of(node));
        }
        return new Node(description, Attributes.of(new Map.Entry[0]), contentOrAttributes);
    }

    public static Node of(String description, Node ... content) {
        return new Node(description, Attributes.of(new Map.Entry[0]), Node.getNodesOrThrow(content));
    }

    public static Node of(String description, Map<String, Object> attributes, Node ... content) {
        return Node.of(description, Attributes.of(attributes), Node.getNodesOrThrow(content));
    }

    public static Node of(String description, Attributes attributes, Node ... content) {
        return new Node(description, attributes, Node.getNodesOrThrow(content));
    }

    public static Node of(String description, Map<String, Object> attributes, Object content) {
        return Node.of(description, Attributes.of(attributes), content);
    }

    public static Node of(String description, Attributes attributes, Object content) {
        if (content instanceof List) {
            List list = (List)content;
            try {
                return new Node(description, attributes, Node.getNodesOrThrow(list));
            }
            catch (ClassCastException exception) {
                throw new IllegalArgumentException("Unexpected attributes type: " + content.getClass().getName(), exception);
            }
        }
        if (content instanceof Node) {
            Node node = (Node)content;
            return new Node(description, attributes, List.of(node));
        }
        return new Node(description, attributes, content);
    }

    private static Attributes getAttributesOrThrow(Map<?, ?> attributes) {
        try {
            return Attributes.of(attributes);
        }
        catch (ClassCastException exception) {
            throw new IllegalArgumentException("Unexpected attributes type: " + attributes.getClass().getName(), exception);
        }
    }

    private static Collection<Node> getNodesOrThrow(Node[] entries) {
        if (entries == null) {
            return null;
        }
        return Arrays.stream(entries).filter(Objects::nonNull).toList();
    }

    private static Collection<Node> getNodesOrThrow(Collection<?> entries) {
        try {
            if (entries == null) {
                return null;
            }
            Collection<?> results = entries;
            if (results.isEmpty()) {
                return null;
            }
            return results.stream().filter(Objects::nonNull).toList();
        }
        catch (ClassCastException exception) {
            throw new IllegalArgumentException("Unexpected payload type: expected nodes collection", exception);
        }
    }

    public Optional<String> contentAsString() {
        Object object = this.content;
        if (object instanceof String) {
            String string = (String)object;
            return Optional.of(string);
        }
        object = this.content;
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return Optional.of(new String(bytes, StandardCharsets.UTF_8));
        }
        return Optional.empty();
    }

    public Optional<byte[]> contentAsBytes() {
        Optional<byte[]> optional;
        Object object = this.content;
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            optional = Optional.of(bytes);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public OptionalLong contentAsLong() {
        OptionalLong optionalLong;
        Object object = this.content;
        if (object instanceof Number) {
            Number number = (Number)object;
            optionalLong = OptionalLong.of(number.longValue());
        } else {
            optionalLong = OptionalLong.empty();
        }
        return optionalLong;
    }

    public OptionalDouble contentAsDouble() {
        OptionalDouble optionalDouble;
        Object object = this.content;
        if (object instanceof Number) {
            Number number = (Number)object;
            optionalDouble = OptionalDouble.of(number.doubleValue());
        } else {
            optionalDouble = OptionalDouble.empty();
        }
        return optionalDouble;
    }

    public Optional<Boolean> contentAsBoolean() {
        Object object = this.content;
        if (object instanceof String) {
            String string = (String)object;
            return Optional.of(Boolean.parseBoolean(string.toLowerCase(Locale.ROOT)));
        }
        object = this.content;
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return Optional.of(Boolean.parseBoolean(new String(bytes, StandardCharsets.UTF_8).toLowerCase(Locale.ROOT)));
        }
        return Optional.empty();
    }

    public boolean hasNode(String description) {
        return this.children().stream().anyMatch(node -> Objects.equals(node.description(), description));
    }

    public LinkedList<Node> children() {
        if (this.content == null) {
            return new LinkedList<Node>();
        }
        Object object = this.content;
        if (!(object instanceof Collection)) {
            return new LinkedList<Node>();
        }
        Collection collection = (Collection)object;
        return collection.stream().filter(entry -> entry instanceof Node).map(entry -> (Node)entry).collect(Collectors.toCollection(LinkedList::new));
    }

    public boolean hasDescription(String description) {
        return Objects.equals(this.description(), description);
    }

    public Optional<Node> findChild() {
        return this.children().stream().findFirst();
    }

    public Optional<Node> findChild(String description) {
        return this.children().stream().filter(node -> Objects.equals(node.description(), description)).findFirst();
    }

    public List<Node> listChildren(String description) {
        return this.streamChildren(description).toList();
    }

    public Stream<Node> streamChildren(String description) {
        return this.children().stream().filter(node -> Objects.equals(node.description(), description));
    }

    public int size() {
        int descriptionSize = 1;
        int attributesSize = 2 * this.attributes.toMap().size();
        int contentSize = this.hasContent() ? 1 : 0;
        return descriptionSize + attributesSize + contentSize;
    }

    public boolean hasContent() {
        return Objects.nonNull(this.content);
    }

    public String id() {
        return this.attributes.getString("id", null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Node)) return false;
        Node that = (Node)other;
        if (!Objects.equals(this.description(), that.description())) return false;
        if (!Objects.equals(this.attributes(), that.attributes())) return false;
        if (Objects.equals(this.content(), that.content())) return true;
        Object object = this.content();
        if (!(object instanceof byte[])) return false;
        byte[] theseBytes = (byte[])object;
        object = that.content();
        if (!(object instanceof byte[])) return false;
        byte[] thoseBytes = (byte[])object;
        if (!Arrays.equals(theseBytes, thoseBytes)) return false;
        return true;
    }

    @Override
    public String toString() {
        String description = this.description.isBlank() ? "" : "description=%s".formatted(this.description);
        String attributes = this.attributes.toMap().isEmpty() ? "" : ", attributes=%s".formatted(this.attributes.toMap());
        String content = this.content == null ? "" : ", content=%s".formatted(this.contentToString());
        return "Node[%s%s%s]".formatted(description, attributes, content);
    }

    private Object contentToString() {
        Object object = this.content;
        if (!(object instanceof byte[])) {
            return this.content;
        }
        byte[] bytes = (byte[])object;
        return this.hasDescription("result") || this.hasDescription("query") || this.hasDescription("body") ? new String(bytes) : Arrays.toString(bytes);
    }

    public String toJson() {
        return Json.writeValueAsString(this, true);
    }
}

