/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.poll;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.message.model.ChatMessageKey;
import it.auties.whatsapp.model.message.model.ChatMessageKeySpec;
import it.auties.whatsapp.model.poll.PollUpdate;
import it.auties.whatsapp.model.poll.PollUpdateEncryptedOptions;
import it.auties.whatsapp.model.poll.PollUpdateEncryptedOptionsSpec;

public class PollUpdateSpec {
    public static byte[] encode(PollUpdate protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)PollUpdateSpec.sizeOf(protoInputObject));
        PollUpdateSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(PollUpdate protoInputObject, ProtobufOutputStream protoOutputStream) {
        PollUpdateEncryptedOptions vote;
        if (protoInputObject == null) {
            return;
        }
        ChatMessageKey pollUpdateMessageKey = protoInputObject.pollUpdateMessageKey();
        if (pollUpdateMessageKey != null) {
            protoOutputStream.writeMessage(1, ChatMessageKeySpec.sizeOf(pollUpdateMessageKey));
            ChatMessageKeySpec.encode(pollUpdateMessageKey, protoOutputStream);
        }
        if ((vote = protoInputObject.vote()) != null) {
            protoOutputStream.writeMessage(2, PollUpdateEncryptedOptionsSpec.sizeOf(vote));
            PollUpdateEncryptedOptionsSpec.encode(vote, protoOutputStream);
        }
        long senderTimestampMilliseconds = protoInputObject.senderTimestampMilliseconds();
        protoOutputStream.writeInt64(3, Long.valueOf(senderTimestampMilliseconds));
    }

    public static PollUpdate decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return PollUpdateSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static PollUpdate decode(ProtobufInputStream protoInputStream) {
        ChatMessageKey pollUpdateMessageKey = null;
        PollUpdateEncryptedOptions vote = null;
        long senderTimestampMilliseconds = 0L;
        block5: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    pollUpdateMessageKey = ChatMessageKeySpec.decode(protoInputStream.readLengthDelimited());
                    continue block5;
                }
                case 2: {
                    vote = PollUpdateEncryptedOptionsSpec.decode(protoInputStream.readLengthDelimited());
                    continue block5;
                }
                case 3: {
                    senderTimestampMilliseconds = protoInputStream.readInt64();
                    continue block5;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new PollUpdate(pollUpdateMessageKey, vote, senderTimestampMilliseconds);
    }

    public static int sizeOf(PollUpdate protoInputObject) {
        PollUpdateEncryptedOptions vote;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        ChatMessageKey pollUpdateMessageKey = protoInputObject.pollUpdateMessageKey();
        if (pollUpdateMessageKey != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            int pollUpdateMessageKeySerializedSize = ChatMessageKeySpec.sizeOf(pollUpdateMessageKey);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)pollUpdateMessageKeySerializedSize);
            protoOutputSize += pollUpdateMessageKeySerializedSize;
        }
        if ((vote = protoInputObject.vote()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            int voteSerializedSize = PollUpdateEncryptedOptionsSpec.sizeOf(vote);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)voteSerializedSize);
            protoOutputSize += voteSerializedSize;
        }
        long senderTimestampMilliseconds = protoInputObject.senderTimestampMilliseconds();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)0);
        return protoOutputSize += ProtobufOutputStream.getVarIntSize((long)senderTimestampMilliseconds);
    }
}

