/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.privacy;

import it.auties.whatsapp.util.Clock;
import java.time.ZonedDateTime;

public sealed interface GdprAccountReport {
    public static Pending ofPending(long timestamp) {
        return new Pending(Clock.parseSeconds(timestamp).orElseGet(() -> ZonedDateTime.now().plusDays(3L)));
    }

    public static Ready ofReady() {
        return new Ready();
    }

    public static Error ofError() {
        return new Error();
    }

    public Type type();

    public record Pending(ZonedDateTime dateTime) implements GdprAccountReport
    {
        @Override
        public Type type() {
            return Type.PENDING;
        }
    }

    public record Ready() implements GdprAccountReport
    {
        @Override
        public Type type() {
            return Type.READY;
        }
    }

    public record Error() implements GdprAccountReport
    {
        @Override
        public Type type() {
            return Type.ERROR;
        }
    }

    public static enum Type {
        PENDING,
        ERROR,
        READY;

    }
}

