/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.privacy;

import it.auties.protobuf.annotation.ProtobufEnum;
import it.auties.whatsapp.model.privacy.PrivacySettingValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@ProtobufEnum
public enum PrivacySettingType {
    LAST_SEEN(0, "last", Set.of(PrivacySettingValue.EVERYONE, PrivacySettingValue.CONTACTS, PrivacySettingValue.CONTACTS_EXCEPT, PrivacySettingValue.NOBODY)),
    ONLINE(1, "online", Set.of(PrivacySettingValue.EVERYONE, PrivacySettingValue.MATCH_LAST_SEEN)),
    PROFILE_PIC(2, "profile", Set.of(PrivacySettingValue.EVERYONE, PrivacySettingValue.CONTACTS, PrivacySettingValue.CONTACTS_EXCEPT, PrivacySettingValue.NOBODY)),
    STATUS(3, "status", Set.of(PrivacySettingValue.EVERYONE, PrivacySettingValue.CONTACTS, PrivacySettingValue.CONTACTS_EXCEPT, PrivacySettingValue.NOBODY)),
    ADD_ME_TO_GROUPS(4, "groupadd", Set.of(PrivacySettingValue.EVERYONE, PrivacySettingValue.CONTACTS, PrivacySettingValue.CONTACTS_EXCEPT)),
    READ_RECEIPTS(5, "readreceipts", Set.of(PrivacySettingValue.EVERYONE, PrivacySettingValue.NOBODY)),
    CALL_ADD(6, "calladd", Set.of(PrivacySettingValue.EVERYONE));

    final int index;
    private final String data;
    private final Set<PrivacySettingValue> values;

    private PrivacySettingType(int index, String data, Set<PrivacySettingValue> values) {
        this.index = index;
        this.data = data;
        this.values = values;
    }

    public static Optional<PrivacySettingType> of(String id) {
        return Arrays.stream(PrivacySettingType.values()).filter(entry -> Objects.equals(entry.data(), id)).findFirst();
    }

    public int index() {
        return this.index;
    }

    public Set<PrivacySettingValue> supportedValues() {
        return Collections.unmodifiableSet(this.values);
    }

    public boolean isSupported(PrivacySettingValue value) {
        return this.values.contains((Object)value);
    }

    public String data() {
        return this.data;
    }
}

