/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.product;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.model.ProtobufString;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.message.standard.ImageMessage;
import it.auties.whatsapp.model.message.standard.ImageMessageSpec;
import it.auties.whatsapp.model.product.Product;

public class ProductSpec {
    public static byte[] encode(Product protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)ProductSpec.sizeOf(protoInputObject));
        ProductSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(Product protoInputObject, ProtobufOutputStream protoOutputStream) {
        ProtobufString firstImageId0;
        ProtobufString url0;
        String url;
        ProtobufString retailerId0;
        ProtobufString currencyCode0;
        String currencyCode;
        ProtobufString description0;
        String description;
        ProtobufString title0;
        String title;
        ProtobufString id0;
        String id;
        if (protoInputObject == null) {
            return;
        }
        ImageMessage image = protoInputObject.image();
        if (image != null) {
            protoOutputStream.writeMessage(1, ImageMessageSpec.sizeOf(image));
            ImageMessageSpec.encode(image, protoOutputStream);
        }
        if ((id = protoInputObject.id()) != null && (id0 = ProtobufLazyMixin.toValue((String)id)) != null) {
            protoOutputStream.writeString(2, id0);
        }
        if ((title = protoInputObject.title()) != null && (title0 = ProtobufLazyMixin.toValue((String)title)) != null) {
            protoOutputStream.writeString(3, title0);
        }
        if ((description = protoInputObject.description()) != null && (description0 = ProtobufLazyMixin.toValue((String)description)) != null) {
            protoOutputStream.writeString(4, description0);
        }
        if ((currencyCode = protoInputObject.currencyCode()) != null && (currencyCode0 = ProtobufLazyMixin.toValue((String)currencyCode)) != null) {
            protoOutputStream.writeString(5, currencyCode0);
        }
        long priceAmount1000 = protoInputObject.priceAmount1000();
        protoOutputStream.writeInt64(6, Long.valueOf(priceAmount1000));
        String retailerId = protoInputObject.retailerId();
        if (retailerId != null && (retailerId0 = ProtobufLazyMixin.toValue((String)retailerId)) != null) {
            protoOutputStream.writeString(7, retailerId0);
        }
        if ((url = protoInputObject.url()) != null && (url0 = ProtobufLazyMixin.toValue((String)url)) != null) {
            protoOutputStream.writeString(8, url0);
        }
        int productImageCount = protoInputObject.productImageCount();
        protoOutputStream.writeUInt32(9, Integer.valueOf(productImageCount));
        String firstImageId = protoInputObject.firstImageId();
        if (firstImageId != null && (firstImageId0 = ProtobufLazyMixin.toValue((String)firstImageId)) != null) {
            protoOutputStream.writeString(11, firstImageId0);
        }
        long salePriceAmount1000 = protoInputObject.salePriceAmount1000();
        protoOutputStream.writeInt64(12, Long.valueOf(salePriceAmount1000));
    }

    public static Product decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return ProductSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static Product decode(ProtobufInputStream protoInputStream) {
        ImageMessage image = null;
        String id = null;
        String title = null;
        String description = null;
        String currencyCode = null;
        long priceAmount1000 = 0L;
        String retailerId = null;
        String url = null;
        int productImageCount = 0;
        String firstImageId = null;
        long salePriceAmount1000 = 0L;
        block13: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    image = ImageMessageSpec.decode(protoInputStream.readLengthDelimited());
                    continue block13;
                }
                case 2: {
                    id = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block13;
                }
                case 3: {
                    title = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block13;
                }
                case 4: {
                    description = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block13;
                }
                case 5: {
                    currencyCode = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block13;
                }
                case 6: {
                    priceAmount1000 = protoInputStream.readInt64();
                    continue block13;
                }
                case 7: {
                    retailerId = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block13;
                }
                case 8: {
                    url = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block13;
                }
                case 9: {
                    productImageCount = protoInputStream.readInt32();
                    continue block13;
                }
                case 11: {
                    firstImageId = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block13;
                }
                case 12: {
                    salePriceAmount1000 = protoInputStream.readInt64();
                    continue block13;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new Product(image, id, title, description, currencyCode, priceAmount1000, retailerId, url, productImageCount, firstImageId, salePriceAmount1000);
    }

    public static int sizeOf(Product protoInputObject) {
        ProtobufString firstImageId0;
        ProtobufString url0;
        String url;
        ProtobufString retailerId0;
        ProtobufString currencyCode0;
        String currencyCode;
        ProtobufString description0;
        String description;
        ProtobufString title0;
        String title;
        ProtobufString id0;
        String id;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        ImageMessage image = protoInputObject.image();
        if (image != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            int imageSerializedSize = ImageMessageSpec.sizeOf(image);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)imageSerializedSize);
            protoOutputSize += imageSerializedSize;
        }
        if ((id = protoInputObject.id()) != null && (id0 = ProtobufLazyMixin.toValue((String)id)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)id0);
        }
        if ((title = protoInputObject.title()) != null && (title0 = ProtobufLazyMixin.toValue((String)title)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)title0);
        }
        if ((description = protoInputObject.description()) != null && (description0 = ProtobufLazyMixin.toValue((String)description)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)description0);
        }
        if ((currencyCode = protoInputObject.currencyCode()) != null && (currencyCode0 = ProtobufLazyMixin.toValue((String)currencyCode)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)5, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)currencyCode0);
        }
        long priceAmount1000 = protoInputObject.priceAmount1000();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)6, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)priceAmount1000);
        String retailerId = protoInputObject.retailerId();
        if (retailerId != null && (retailerId0 = ProtobufLazyMixin.toValue((String)retailerId)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)7, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)retailerId0);
        }
        if ((url = protoInputObject.url()) != null && (url0 = ProtobufLazyMixin.toValue((String)url)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)8, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)url0);
        }
        int productImageCount = protoInputObject.productImageCount();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)9, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)productImageCount);
        String firstImageId = protoInputObject.firstImageId();
        if (firstImageId != null && (firstImageId0 = ProtobufLazyMixin.toValue((String)firstImageId)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)11, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)firstImageId0);
        }
        long salePriceAmount1000 = protoInputObject.salePriceAmount1000();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)12, (int)0);
        return protoOutputSize += ProtobufOutputStream.getVarIntSize((long)salePriceAmount1000);
    }
}

