/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.auth;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.model.ProtobufString;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.signal.auth.CompanionProperties;
import it.auties.whatsapp.model.signal.auth.CompanionPropertiesPlatformTypeSpec;
import it.auties.whatsapp.model.signal.auth.Version;
import it.auties.whatsapp.model.signal.auth.VersionSpec;
import it.auties.whatsapp.model.sync.HistorySyncConfig;
import it.auties.whatsapp.model.sync.HistorySyncConfigSpec;

public class CompanionPropertiesSpec {
    public static byte[] encode(CompanionProperties protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)CompanionPropertiesSpec.sizeOf(protoInputObject));
        CompanionPropertiesSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(CompanionProperties protoInputObject, ProtobufOutputStream protoOutputStream) {
        CompanionProperties.PlatformType platformType;
        Version version;
        ProtobufString os0;
        if (protoInputObject == null) {
            return;
        }
        String os = protoInputObject.os();
        if (os != null && (os0 = ProtobufLazyMixin.toValue((String)os)) != null) {
            protoOutputStream.writeString(1, os0);
        }
        if ((version = protoInputObject.version()) != null) {
            protoOutputStream.writeMessage(2, VersionSpec.sizeOf(version));
            VersionSpec.encode(version, protoOutputStream);
        }
        if ((platformType = protoInputObject.platformType()) != null) {
            Integer platformType0 = CompanionPropertiesPlatformTypeSpec.encode(platformType);
            protoOutputStream.writeInt32(3, platformType0);
        }
        boolean requireFullSync = protoInputObject.requireFullSync();
        protoOutputStream.writeBool(4, Boolean.valueOf(requireFullSync));
        HistorySyncConfig historySyncConfig = protoInputObject.historySyncConfig();
        if (historySyncConfig != null) {
            protoOutputStream.writeMessage(5, HistorySyncConfigSpec.sizeOf(historySyncConfig));
            HistorySyncConfigSpec.encode(historySyncConfig, protoOutputStream);
        }
    }

    public static CompanionProperties decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return CompanionPropertiesSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static CompanionProperties decode(ProtobufInputStream protoInputStream) {
        String os = null;
        Version version = null;
        CompanionProperties.PlatformType platformType = null;
        boolean requireFullSync = false;
        HistorySyncConfig historySyncConfig = null;
        block7: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    os = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block7;
                }
                case 2: {
                    version = VersionSpec.decode(protoInputStream.readLengthDelimited());
                    continue block7;
                }
                case 3: {
                    platformType = CompanionPropertiesPlatformTypeSpec.decode(protoInputStream.readInt32());
                    continue block7;
                }
                case 4: {
                    requireFullSync = protoInputStream.readBool();
                    continue block7;
                }
                case 5: {
                    historySyncConfig = HistorySyncConfigSpec.decode(protoInputStream.readLengthDelimited());
                    continue block7;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new CompanionProperties(os, version, platformType, requireFullSync, historySyncConfig);
    }

    public static int sizeOf(CompanionProperties protoInputObject) {
        CompanionProperties.PlatformType platformType;
        Version version;
        ProtobufString os0;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        String os = protoInputObject.os();
        if (os != null && (os0 = ProtobufLazyMixin.toValue((String)os)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)os0);
        }
        if ((version = protoInputObject.version()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            int versionSerializedSize = VersionSpec.sizeOf(version);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)versionSerializedSize);
            protoOutputSize += versionSerializedSize;
        }
        if ((platformType = protoInputObject.platformType()) != null) {
            Integer platformType0 = CompanionPropertiesPlatformTypeSpec.encode(platformType);
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)2);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)platformType0.intValue());
        }
        boolean requireFullSync = protoInputObject.requireFullSync();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)0);
        ++protoOutputSize;
        HistorySyncConfig historySyncConfig = protoInputObject.historySyncConfig();
        if (historySyncConfig != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)5, (int)2);
            int historySyncConfigSerializedSize = HistorySyncConfigSpec.sizeOf(historySyncConfig);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)historySyncConfigSerializedSize);
            protoOutputSize += historySyncConfigSerializedSize;
        }
        return protoOutputSize;
    }
}

