/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import it.auties.protobuf.annotation.ProtobufMessage;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.crypto.MD5;
import it.auties.whatsapp.util.Validate;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@ProtobufMessage(name="ClientPayload.UserAgent.AppVersion")
public record Version(@ProtobufProperty(index=1, type=ProtobufType.UINT32) Integer primary, @ProtobufProperty(index=2, type=ProtobufType.UINT32) Integer secondary, @ProtobufProperty(index=3, type=ProtobufType.UINT32) Integer tertiary, @ProtobufProperty(index=4, type=ProtobufType.UINT32) Integer quaternary, @ProtobufProperty(index=5, type=ProtobufType.UINT32) Integer quinary) {
    public Version(int primary) {
        this(primary, null, null, null, null);
    }

    public Version(int primary, int secondary, int tertiary) {
        this(primary, secondary, tertiary, null, null);
    }

    @JsonCreator
    public static Version of(String version) {
        String[] tokens = version.split("\\.", 5);
        Validate.isTrue(tokens.length <= 5, "Invalid number of tokens for version %s: %s", version, tokens);
        Integer primary = tokens.length > 0 ? Integer.valueOf(Integer.parseInt(tokens[0])) : null;
        Integer secondary = tokens.length > 1 ? Integer.valueOf(Integer.parseInt(tokens[1])) : null;
        Integer tertiary = tokens.length > 2 ? Integer.valueOf(Integer.parseInt(tokens[2])) : null;
        Integer quaternary = tokens.length > 3 ? Integer.valueOf(Integer.parseInt(tokens[3])) : null;
        Integer quinary = tokens.length > 4 ? Integer.valueOf(Integer.parseInt(tokens[4])) : null;
        return new Version(primary, secondary, tertiary, quaternary, quinary);
    }

    public byte[] toHash() {
        return MD5.calculate(this.toString());
    }

    @Override
    @JsonValue
    public String toString() {
        return Stream.of(this.primary, this.secondary, this.tertiary, this.quaternary, this.quinary).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining("."));
    }
}

