/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.auth;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.model.ProtobufString;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.signal.auth.WebInfo;
import it.auties.whatsapp.model.signal.auth.WebInfoPlatformSpec;
import it.auties.whatsapp.model.signal.auth.WebPayload;
import it.auties.whatsapp.model.signal.auth.WebPayloadSpec;

public class WebInfoSpec {
    public static byte[] encode(WebInfo protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)WebInfoSpec.sizeOf(protoInputObject));
        WebInfoSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(WebInfo protoInputObject, ProtobufOutputStream protoOutputStream) {
        WebInfo.Platform webSubPlatform;
        WebPayload webPayload;
        ProtobufString version0;
        String version;
        ProtobufString refToken0;
        if (protoInputObject == null) {
            return;
        }
        String refToken = protoInputObject.refToken();
        if (refToken != null && (refToken0 = ProtobufLazyMixin.toValue((String)refToken)) != null) {
            protoOutputStream.writeString(1, refToken0);
        }
        if ((version = protoInputObject.version()) != null && (version0 = ProtobufLazyMixin.toValue((String)version)) != null) {
            protoOutputStream.writeString(2, version0);
        }
        if ((webPayload = protoInputObject.webPayload()) != null) {
            protoOutputStream.writeMessage(3, WebPayloadSpec.sizeOf(webPayload));
            WebPayloadSpec.encode(webPayload, protoOutputStream);
        }
        if ((webSubPlatform = protoInputObject.webSubPlatform()) != null) {
            Integer webSubPlatform0 = WebInfoPlatformSpec.encode(webSubPlatform);
            protoOutputStream.writeInt32(4, webSubPlatform0);
        }
    }

    public static WebInfo decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return WebInfoSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static WebInfo decode(ProtobufInputStream protoInputStream) {
        String refToken = null;
        String version = null;
        WebPayload webPayload = null;
        WebInfo.Platform webSubPlatform = null;
        block6: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    refToken = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block6;
                }
                case 2: {
                    version = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block6;
                }
                case 3: {
                    webPayload = WebPayloadSpec.decode(protoInputStream.readLengthDelimited());
                    continue block6;
                }
                case 4: {
                    webSubPlatform = WebInfoPlatformSpec.decode(protoInputStream.readInt32());
                    continue block6;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new WebInfo(refToken, version, webPayload, webSubPlatform);
    }

    public static int sizeOf(WebInfo protoInputObject) {
        WebInfo.Platform webSubPlatform;
        WebPayload webPayload;
        ProtobufString version0;
        String version;
        ProtobufString refToken0;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        String refToken = protoInputObject.refToken();
        if (refToken != null && (refToken0 = ProtobufLazyMixin.toValue((String)refToken)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)refToken0);
        }
        if ((version = protoInputObject.version()) != null && (version0 = ProtobufLazyMixin.toValue((String)version)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)version0);
        }
        if ((webPayload = protoInputObject.webPayload()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)2);
            int webPayloadSerializedSize = WebPayloadSpec.sizeOf(webPayload);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)webPayloadSerializedSize);
            protoOutputSize += webPayloadSerializedSize;
        }
        if ((webSubPlatform = protoInputObject.webSubPlatform()) != null) {
            Integer webSubPlatform0 = WebInfoPlatformSpec.encode(webSubPlatform);
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)2);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)webSubPlatform0.intValue());
        }
        return protoOutputSize;
    }
}

