/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.keypair;

import it.auties.whatsapp.model.node.Node;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalPreKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalSignedKeyPair;
import it.auties.whatsapp.util.Bytes;
import java.util.Arrays;

public sealed interface ISignalKeyPair
permits SignalKeyPair, SignalPreKeyPair, SignalSignedKeyPair {
    public static byte[] toSignalKey(byte[] key) {
        if (key == null) {
            return null;
        }
        return switch (key.length) {
            case 33 -> key;
            case 32 -> {
                byte[] result = new byte[33];
                System.arraycopy(key, 0, result, 1, key.length);
                result[0] = 5;
                yield result;
            }
            default -> throw new IllegalArgumentException("Invalid key size: %s".formatted(key.length));
        };
    }

    public static byte[] toCurveKey(byte[] key) {
        if (key == null) {
            return null;
        }
        return switch (key.length) {
            case 32 -> key;
            case 33 -> Arrays.copyOfRange(key, 1, key.length);
            default -> throw new IllegalArgumentException("Invalid key size: %s".formatted(key.length));
        };
    }

    public byte[] privateKey();

    public Node toNode();

    public SignalKeyPair toGenericKeyPair();

    default public byte[] signalPublicKey() {
        return ISignalKeyPair.toSignalKey(this.publicKey());
    }

    public byte[] publicKey();

    default public byte[] encodedId() {
        return Bytes.intToBytes(this.id(), 3);
    }

    default public int id() {
        throw new UnsupportedOperationException(this.getClass().getName() + " doesn't provide an id");
    }
}

