/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.keypair;

import it.auties.curve25519.Curve25519;
import it.auties.protobuf.annotation.ProtobufMessage;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.node.Node;
import it.auties.whatsapp.model.signal.keypair.ISignalKeyPair;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;

@ProtobufMessage
public record SignalKeyPair(@ProtobufProperty(index=1, type=ProtobufType.BYTES) byte[] publicKey, @ProtobufProperty(index=2, type=ProtobufType.BYTES) byte[] privateKey) implements ISignalKeyPair
{
    public SignalKeyPair(byte[] publicKey, byte[] privateKey) {
        this.publicKey = ISignalKeyPair.toCurveKey(publicKey);
        this.privateKey = privateKey;
    }

    public static SignalKeyPair of(byte[] publicKey) {
        return new SignalKeyPair(publicKey, null);
    }

    public static SignalKeyPair random() {
        KeyPair keyPair = Curve25519.randomKeyPair();
        byte[] publicKey = Curve25519.readKey((PublicKey)keyPair.getPublic());
        byte[] privateKey = Curve25519.readKey((PrivateKey)keyPair.getPrivate());
        return new SignalKeyPair(publicKey, privateKey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SignalKeyPair)) return false;
        SignalKeyPair that = (SignalKeyPair)other;
        if (!Arrays.equals(this.publicKey(), that.publicKey())) return false;
        if (!Arrays.equals(this.privateKey(), that.privateKey())) return false;
        return true;
    }

    @Override
    public Node toNode() {
        throw new UnsupportedOperationException("Cannot serialize generic signal key pair");
    }

    @Override
    public SignalKeyPair toGenericKeyPair() {
        return this;
    }
}

