/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import it.auties.protobuf.annotation.ProtobufMessage;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.signal.message.SignalMessageSpec;
import it.auties.whatsapp.model.signal.message.SignalProtocolMessage;
import it.auties.whatsapp.util.Bytes;
import java.util.Arrays;
import java.util.Objects;

@ProtobufMessage(name="SignalMessage")
public final class SignalMessage
extends SignalProtocolMessage<SignalMessage> {
    @ProtobufProperty(index=1, type=ProtobufType.BYTES)
    private final byte[] ephemeralPublicKey;
    @ProtobufProperty(index=2, type=ProtobufType.UINT32)
    private final Integer counter;
    @ProtobufProperty(index=3, type=ProtobufType.UINT32)
    private final Integer previousCounter;
    @ProtobufProperty(index=4, type=ProtobufType.BYTES)
    private final byte[] ciphertext;
    private byte[] signature;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public SignalMessage(byte[] ephemeralPublicKey, Integer counter, Integer previousCounter, byte[] ciphertext, byte[] signature) {
        this.ephemeralPublicKey = ephemeralPublicKey;
        this.counter = counter;
        this.previousCounter = previousCounter;
        this.ciphertext = ciphertext;
        this.signature = signature;
    }

    public SignalMessage(byte[] ephemeralPublicKey, Integer counter, Integer previousCounter, byte[] ciphertext) {
        this.ephemeralPublicKey = ephemeralPublicKey;
        this.counter = counter;
        this.previousCounter = previousCounter;
        this.ciphertext = ciphertext;
    }

    public static SignalMessage ofSerialized(byte[] serialized) {
        byte[] data = Arrays.copyOfRange(serialized, 1, serialized.length - 8);
        byte[] signature = Arrays.copyOfRange(serialized, serialized.length - 8, serialized.length);
        return ((SignalMessage)((SignalMessage)SignalMessageSpec.decode(data).setVersion(Bytes.bytesToVersion(serialized[0]))).setSerialized(serialized)).setSignature(signature);
    }

    @Override
    public byte[] serialized() {
        if (this.serialized == null) {
            byte[] encodedMessage = Bytes.concat(this.serializedVersion(), SignalMessageSpec.encode(this));
            this.serialized = Bytes.concat(encodedMessage, Objects.requireNonNull(this.signature, "Message wasn't signed"));
        }
        return this.serialized;
    }

    public byte[] ephemeralPublicKey() {
        return this.ephemeralPublicKey;
    }

    public Integer counter() {
        return this.counter;
    }

    public Integer previousCounter() {
        return this.previousCounter;
    }

    public byte[] ciphertext() {
        return this.ciphertext;
    }

    public byte[] signature() {
        return this.signature;
    }

    public SignalMessage setSignature(byte[] signature) {
        this.signature = signature;
        return this;
    }
}

