/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.message;

import it.auties.whatsapp.model.signal.message.SenderKeyMessage;
import it.auties.whatsapp.model.signal.message.SignalDistributionMessage;
import it.auties.whatsapp.model.signal.message.SignalMessage;
import it.auties.whatsapp.model.signal.message.SignalPreKeyMessage;
import it.auties.whatsapp.util.Bytes;

public abstract sealed class SignalProtocolMessage<T extends SignalProtocolMessage<T>>
permits SenderKeyMessage, SignalDistributionMessage, SignalMessage, SignalPreKeyMessage {
    protected byte[] serialized;
    private int version;

    public SignalProtocolMessage() {
        this.version = 3;
    }

    public SignalProtocolMessage(int version, byte[] serialized) {
        this.version = version;
        this.serialized = serialized;
    }

    public int version() {
        return this.version;
    }

    public T setVersion(int version) {
        this.version = version;
        return (T)this;
    }

    public byte serializedVersion() {
        return Bytes.versionToBytes(this.version);
    }

    public T setSerialized(byte[] serialized) {
        this.serialized = serialized;
        return (T)this;
    }

    public abstract byte[] serialized();
}

