/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.sender;

import com.fasterxml.jackson.annotation.JsonCreator;
import it.auties.protobuf.annotation.ProtobufMessage;
import it.auties.protobuf.annotation.ProtobufProperty;
import it.auties.protobuf.model.ProtobufType;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.sender.SenderKeyState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

@ProtobufMessage
public final class SenderKeyRecord {
    @ProtobufProperty(index=1, type=ProtobufType.MESSAGE)
    private final List<SenderKeyState> states;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public SenderKeyRecord(List<SenderKeyState> states) {
        this.states = states;
    }

    public SenderKeyRecord() {
        this.states = new ArrayList<SenderKeyState>();
    }

    public SenderKeyState firstState() {
        return (SenderKeyState)this.states.stream().findFirst().orElseThrow(() -> new NoSuchElementException("Cannot get head state for empty record"));
    }

    public List<SenderKeyState> findStatesById(int keyId) {
        return this.states.stream().filter(entry -> entry.id() == keyId).toList();
    }

    public void addState(int id, byte[] signatureKey, int iteration, byte[] seed) {
        this.addState(id, SignalKeyPair.of(signatureKey), iteration, seed);
    }

    public void addState(int id, SignalKeyPair signingKey, int iteration, byte[] seed) {
        SenderKeyState state = new SenderKeyState(id, signingKey, iteration, seed);
        this.states.add(state);
    }

    public List<SenderKeyState> states() {
        return Collections.unmodifiableList(this.states);
    }

    public boolean isEmpty() {
        return this.states.isEmpty();
    }

    public int hashCode() {
        return Objects.hashCode(this.states);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof SenderKeyRecord)) return false;
        SenderKeyRecord that = (SenderKeyRecord)object;
        if (!Objects.equals(this.states, that.states)) return false;
        return true;
    }
}

