/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.sender;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec;
import it.auties.whatsapp.model.signal.sender.SenderChainKey;
import it.auties.whatsapp.model.signal.sender.SenderChainKeySpec;
import it.auties.whatsapp.model.signal.sender.SenderKeyState;
import it.auties.whatsapp.model.signal.sender.SenderMessageKey;
import it.auties.whatsapp.model.signal.sender.SenderMessageKeySpec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SenderKeyStateSpec {
    public static byte[] encode(SenderKeyState protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)SenderKeyStateSpec.sizeOf(protoInputObject));
        SenderKeyStateSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(SenderKeyState protoInputObject, ProtobufOutputStream protoOutputStream) {
        SenderChainKey chainKey;
        if (protoInputObject == null) {
            return;
        }
        int id = protoInputObject.id();
        protoOutputStream.writeInt32(1, Integer.valueOf(id));
        SignalKeyPair signingKey = protoInputObject.signingKey();
        if (signingKey != null) {
            protoOutputStream.writeMessage(2, SignalKeyPairSpec.sizeOf(signingKey));
            SignalKeyPairSpec.encode(signingKey, protoOutputStream);
        }
        if (protoInputObject.messageKeys() != null) {
            for (Map.Entry<Integer, SenderMessageKey> messageKeysEntry : protoInputObject.messageKeys().entrySet()) {
                protoOutputStream.writeMessage(3, SenderKeyStateSpec.sizeOfMessageKeys(messageKeysEntry));
                protoOutputStream.writeInt32(1, messageKeysEntry.getKey());
                SenderMessageKey messageKeysValue = messageKeysEntry.getValue();
                if (messageKeysValue == null) continue;
                protoOutputStream.writeMessage(2, SenderMessageKeySpec.sizeOf(messageKeysValue));
                SenderMessageKeySpec.encode(messageKeysValue, protoOutputStream);
            }
        }
        if ((chainKey = protoInputObject.chainKey()) != null) {
            protoOutputStream.writeMessage(4, SenderChainKeySpec.sizeOf(chainKey));
            SenderChainKeySpec.encode(chainKey, protoOutputStream);
        }
    }

    public static SenderKeyState decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return SenderKeyStateSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static SenderKeyState decode(ProtobufInputStream protoInputStream) {
        int id = 0;
        SignalKeyPair signingKey = null;
        ConcurrentHashMap<Integer, SenderMessageKey> messageKeys = new ConcurrentHashMap<Integer, SenderMessageKey>();
        SenderChainKey chainKey = null;
        block10: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    id = protoInputStream.readInt32();
                    continue block10;
                }
                case 2: {
                    signingKey = SignalKeyPairSpec.decode(protoInputStream.readLengthDelimited());
                    continue block10;
                }
                case 3: {
                    ProtobufInputStream messageKeysInputStream = protoInputStream.readLengthDelimited();
                    Integer messageKeysKey = null;
                    SenderMessageKey messageKeysValue = null;
                    while (messageKeysInputStream.readTag()) {
                        switch (messageKeysInputStream.index()) {
                            case 1: {
                                messageKeysKey = messageKeysInputStream.readInt32();
                                break;
                            }
                            case 2: {
                                messageKeysValue = SenderMessageKeySpec.decode(messageKeysInputStream.readLengthDelimited());
                            }
                        }
                    }
                    messageKeys.put(messageKeysKey, messageKeysValue);
                    continue block10;
                }
                case 4: {
                    chainKey = SenderChainKeySpec.decode(protoInputStream.readLengthDelimited());
                    continue block10;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new SenderKeyState(id, signingKey, messageKeys, chainKey);
    }

    public static int sizeOf(SenderKeyState protoInputObject) {
        SenderChainKey chainKey;
        Map<Integer, SenderMessageKey> messageKeysMapField;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        int id = protoInputObject.id();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)id);
        SignalKeyPair signingKey = protoInputObject.signingKey();
        if (signingKey != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            int signingKeySerializedSize = SignalKeyPairSpec.sizeOf(signingKey);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)signingKeySerializedSize);
            protoOutputSize += signingKeySerializedSize;
        }
        if ((messageKeysMapField = protoInputObject.messageKeys()) != null) {
            for (Map.Entry<Integer, SenderMessageKey> messageKeysMapEntry : messageKeysMapField.entrySet()) {
                protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)2);
                int messageKeysMapEntrySize = SenderKeyStateSpec.sizeOfMessageKeys(messageKeysMapEntry);
                protoOutputSize += ProtobufOutputStream.getVarIntSize((long)messageKeysMapEntrySize);
                protoOutputSize += messageKeysMapEntrySize;
            }
        }
        if ((chainKey = protoInputObject.chainKey()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)2);
            int chainKeySerializedSize = SenderChainKeySpec.sizeOf(chainKey);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)chainKeySerializedSize);
            protoOutputSize += chainKeySerializedSize;
        }
        return protoOutputSize;
    }

    private static int sizeOfMessageKeys(Map.Entry<Integer, SenderMessageKey> protoInputObject) {
        SenderMessageKey messageKeysMapValue;
        int protoOutputSize = 0;
        Integer messageKeysMapKey = protoInputObject.getKey();
        if (messageKeysMapKey != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)messageKeysMapKey.intValue());
        }
        if ((messageKeysMapValue = protoInputObject.getValue()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            int messageKeysMapValueSerializedSize = SenderMessageKeySpec.sizeOf(messageKeysMapValue);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)messageKeysMapValueSerializedSize);
            protoOutputSize += messageKeysMapValueSerializedSize;
        }
        return protoOutputSize;
    }
}

