/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.session;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.model.ProtobufString;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPairSpec;
import it.auties.whatsapp.model.signal.session.SessionChain;
import it.auties.whatsapp.model.signal.session.SessionChainSpec;
import it.auties.whatsapp.model.signal.session.SessionPreKey;
import it.auties.whatsapp.model.signal.session.SessionPreKeySpec;
import it.auties.whatsapp.model.signal.session.SessionState;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SessionStateSpec {
    public static byte[] encode(SessionState protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)SessionStateSpec.sizeOf(protoInputObject));
        SessionStateSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(SessionState protoInputObject, ProtobufOutputStream protoOutputStream) {
        ByteBuffer lastRemoteEphemeralKey0;
        byte[] lastRemoteEphemeralKey;
        SignalKeyPair ephemeralKeyPair;
        SessionPreKey sessionPreKey;
        ByteBuffer byteBuffer;
        byte[] rootKey;
        Object remoteIdentityKey0;
        byte[] remoteIdentityKey;
        ByteBuffer baseKey0;
        if (protoInputObject == null) {
            return;
        }
        int version = protoInputObject.version();
        protoOutputStream.writeInt32(1, Integer.valueOf(version));
        int registrationId = protoInputObject.registrationId();
        protoOutputStream.writeInt32(2, Integer.valueOf(registrationId));
        byte[] baseKey = protoInputObject.baseKey();
        if (baseKey != null && (baseKey0 = ProtobufLazyMixin.toValue((byte[])baseKey)) != null) {
            protoOutputStream.writeBytes(3, baseKey0);
        }
        if ((remoteIdentityKey = protoInputObject.remoteIdentityKey()) != null && (remoteIdentityKey0 = ProtobufLazyMixin.toValue((byte[])remoteIdentityKey)) != null) {
            protoOutputStream.writeBytes(4, (ByteBuffer)remoteIdentityKey0);
        }
        if (protoInputObject.chains() != null) {
            for (Map.Entry entry : protoInputObject.chains().entrySet()) {
                SessionChain chainsValue;
                protoOutputStream.writeMessage(5, SessionStateSpec.sizeOfChains(entry));
                ProtobufString chainsKey0 = ProtobufLazyMixin.toValue((String)((String)entry.getKey()));
                if (chainsKey0 != null) {
                    protoOutputStream.writeString(1, chainsKey0);
                }
                if ((chainsValue = (SessionChain)entry.getValue()) == null) continue;
                protoOutputStream.writeMessage(2, SessionChainSpec.sizeOf(chainsValue));
                SessionChainSpec.encode(chainsValue, protoOutputStream);
            }
        }
        if ((rootKey = protoInputObject.rootKey()) != null && (byteBuffer = ProtobufLazyMixin.toValue((byte[])rootKey)) != null) {
            protoOutputStream.writeBytes(6, byteBuffer);
        }
        if ((sessionPreKey = protoInputObject.pendingPreKey()) != null) {
            protoOutputStream.writeMessage(7, SessionPreKeySpec.sizeOf(sessionPreKey));
            SessionPreKeySpec.encode(sessionPreKey, protoOutputStream);
        }
        if ((ephemeralKeyPair = protoInputObject.ephemeralKeyPair()) != null) {
            protoOutputStream.writeMessage(8, SignalKeyPairSpec.sizeOf(ephemeralKeyPair));
            SignalKeyPairSpec.encode(ephemeralKeyPair, protoOutputStream);
        }
        if ((lastRemoteEphemeralKey = protoInputObject.lastRemoteEphemeralKey()) != null && (lastRemoteEphemeralKey0 = ProtobufLazyMixin.toValue((byte[])lastRemoteEphemeralKey)) != null) {
            protoOutputStream.writeBytes(9, lastRemoteEphemeralKey0);
        }
        int previousCounter = protoInputObject.previousCounter();
        protoOutputStream.writeInt32(10, Integer.valueOf(previousCounter));
        boolean closed = protoInputObject.closed();
        protoOutputStream.writeBool(11, Boolean.valueOf(closed));
    }

    public static SessionState decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return SessionStateSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static SessionState decode(ProtobufInputStream protoInputStream) {
        int version = 0;
        int registrationId = 0;
        byte[] baseKey = null;
        byte[] remoteIdentityKey = null;
        ConcurrentHashMap<String, SessionChain> chains = new ConcurrentHashMap<String, SessionChain>();
        byte[] rootKey = null;
        SessionPreKey pendingPreKey = null;
        SignalKeyPair ephemeralKeyPair = null;
        byte[] lastRemoteEphemeralKey = null;
        int previousCounter = 0;
        boolean closed = false;
        block17: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    version = protoInputStream.readInt32();
                    continue block17;
                }
                case 2: {
                    registrationId = protoInputStream.readInt32();
                    continue block17;
                }
                case 3: {
                    baseKey = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block17;
                }
                case 4: {
                    remoteIdentityKey = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block17;
                }
                case 5: {
                    ProtobufInputStream chainsInputStream = protoInputStream.readLengthDelimited();
                    String chainsKey = null;
                    SessionChain chainsValue = null;
                    while (chainsInputStream.readTag()) {
                        switch (chainsInputStream.index()) {
                            case 1: {
                                chainsKey = ProtobufLazyMixin.ofNullable((ProtobufString)chainsInputStream.readString());
                                break;
                            }
                            case 2: {
                                chainsValue = SessionChainSpec.decode(chainsInputStream.readLengthDelimited());
                            }
                        }
                    }
                    chains.put(chainsKey, chainsValue);
                    continue block17;
                }
                case 6: {
                    rootKey = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block17;
                }
                case 7: {
                    pendingPreKey = SessionPreKeySpec.decode(protoInputStream.readLengthDelimited());
                    continue block17;
                }
                case 8: {
                    ephemeralKeyPair = SignalKeyPairSpec.decode(protoInputStream.readLengthDelimited());
                    continue block17;
                }
                case 9: {
                    lastRemoteEphemeralKey = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block17;
                }
                case 10: {
                    previousCounter = protoInputStream.readInt32();
                    continue block17;
                }
                case 11: {
                    closed = protoInputStream.readBool();
                    continue block17;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new SessionState(version, registrationId, baseKey, remoteIdentityKey, chains, rootKey, pendingPreKey, ephemeralKeyPair, lastRemoteEphemeralKey, previousCounter, closed);
    }

    public static int sizeOf(SessionState protoInputObject) {
        ByteBuffer lastRemoteEphemeralKey0;
        byte[] lastRemoteEphemeralKey;
        SignalKeyPair ephemeralKeyPair;
        SessionPreKey pendingPreKey;
        ByteBuffer rootKey0;
        byte[] rootKey;
        Map<String, SessionChain> chainsMapField;
        ByteBuffer remoteIdentityKey0;
        byte[] remoteIdentityKey;
        ByteBuffer baseKey0;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        int version = protoInputObject.version();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)version);
        int registrationId = protoInputObject.registrationId();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)registrationId);
        byte[] baseKey = protoInputObject.baseKey();
        if (baseKey != null && (baseKey0 = ProtobufLazyMixin.toValue((byte[])baseKey)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)baseKey0);
        }
        if ((remoteIdentityKey = protoInputObject.remoteIdentityKey()) != null && (remoteIdentityKey0 = ProtobufLazyMixin.toValue((byte[])remoteIdentityKey)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)remoteIdentityKey0);
        }
        if ((chainsMapField = protoInputObject.chains()) != null) {
            for (Map.Entry<String, SessionChain> chainsMapEntry : chainsMapField.entrySet()) {
                protoOutputSize += ProtobufOutputStream.getFieldSize((int)5, (int)2);
                int chainsMapEntrySize = SessionStateSpec.sizeOfChains(chainsMapEntry);
                protoOutputSize += ProtobufOutputStream.getVarIntSize((long)chainsMapEntrySize);
                protoOutputSize += chainsMapEntrySize;
            }
        }
        if ((rootKey = protoInputObject.rootKey()) != null && (rootKey0 = ProtobufLazyMixin.toValue((byte[])rootKey)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)6, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)rootKey0);
        }
        if ((pendingPreKey = protoInputObject.pendingPreKey()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)7, (int)2);
            int pendingPreKeySerializedSize = SessionPreKeySpec.sizeOf(pendingPreKey);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)pendingPreKeySerializedSize);
            protoOutputSize += pendingPreKeySerializedSize;
        }
        if ((ephemeralKeyPair = protoInputObject.ephemeralKeyPair()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)8, (int)2);
            int ephemeralKeyPairSerializedSize = SignalKeyPairSpec.sizeOf(ephemeralKeyPair);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)ephemeralKeyPairSerializedSize);
            protoOutputSize += ephemeralKeyPairSerializedSize;
        }
        if ((lastRemoteEphemeralKey = protoInputObject.lastRemoteEphemeralKey()) != null && (lastRemoteEphemeralKey0 = ProtobufLazyMixin.toValue((byte[])lastRemoteEphemeralKey)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)9, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)lastRemoteEphemeralKey0);
        }
        int previousCounter = protoInputObject.previousCounter();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)10, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)previousCounter);
        boolean closed = protoInputObject.closed();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)11, (int)0);
        return ++protoOutputSize;
    }

    private static int sizeOfChains(Map.Entry<String, SessionChain> protoInputObject) {
        SessionChain chainsMapValue;
        ProtobufString chainsMapKey0;
        int protoOutputSize = 0;
        String chainsMapKey = protoInputObject.getKey();
        if (chainsMapKey != null && (chainsMapKey0 = ProtobufLazyMixin.toValue((String)chainsMapKey)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)chainsMapKey0);
        }
        if ((chainsMapValue = protoInputObject.getValue()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            int chainsMapValueSerializedSize = SessionChainSpec.sizeOf(chainsMapValue);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)chainsMapValueSerializedSize);
            protoOutputSize += chainsMapValueSerializedSize;
        }
        return protoOutputSize;
    }
}

