/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.sync.AppStateSyncKeyData;
import it.auties.whatsapp.model.sync.AppStateSyncKeyFingerprint;
import it.auties.whatsapp.model.sync.AppStateSyncKeyFingerprintSpec;
import java.nio.ByteBuffer;

public class AppStateSyncKeyDataSpec {
    public static byte[] encode(AppStateSyncKeyData protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)AppStateSyncKeyDataSpec.sizeOf(protoInputObject));
        AppStateSyncKeyDataSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(AppStateSyncKeyData protoInputObject, ProtobufOutputStream protoOutputStream) {
        Long timestamp;
        AppStateSyncKeyFingerprint fingerprint;
        ByteBuffer keyData0;
        if (protoInputObject == null) {
            return;
        }
        byte[] keyData = protoInputObject.keyData();
        if (keyData != null && (keyData0 = ProtobufLazyMixin.toValue((byte[])keyData)) != null) {
            protoOutputStream.writeBytes(1, keyData0);
        }
        if ((fingerprint = protoInputObject.fingerprint()) != null) {
            protoOutputStream.writeMessage(2, AppStateSyncKeyFingerprintSpec.sizeOf(fingerprint));
            AppStateSyncKeyFingerprintSpec.encode(fingerprint, protoOutputStream);
        }
        if ((timestamp = protoInputObject.timestamp()) != null) {
            protoOutputStream.writeInt64(3, timestamp);
        }
    }

    public static AppStateSyncKeyData decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return AppStateSyncKeyDataSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static AppStateSyncKeyData decode(ProtobufInputStream protoInputStream) {
        byte[] keyData = null;
        AppStateSyncKeyFingerprint fingerprint = null;
        Long timestamp = null;
        block5: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    keyData = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block5;
                }
                case 2: {
                    fingerprint = AppStateSyncKeyFingerprintSpec.decode(protoInputStream.readLengthDelimited());
                    continue block5;
                }
                case 3: {
                    timestamp = protoInputStream.readInt64();
                    continue block5;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new AppStateSyncKeyData(keyData, fingerprint, timestamp);
    }

    public static int sizeOf(AppStateSyncKeyData protoInputObject) {
        Long timestamp;
        AppStateSyncKeyFingerprint fingerprint;
        ByteBuffer keyData0;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        byte[] keyData = protoInputObject.keyData();
        if (keyData != null && (keyData0 = ProtobufLazyMixin.toValue((byte[])keyData)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)keyData0);
        }
        if ((fingerprint = protoInputObject.fingerprint()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
            int fingerprintSerializedSize = AppStateSyncKeyFingerprintSpec.sizeOf(fingerprint);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)fingerprintSerializedSize);
            protoOutputSize += fingerprintSerializedSize;
        }
        if ((timestamp = protoInputObject.timestamp()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)timestamp);
        }
        return protoOutputSize;
    }
}

