/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.builtin.ProtobufRepeatedMixin;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.sync.DeviceListMetadata;
import java.nio.ByteBuffer;
import java.util.List;

public class DeviceListMetadataSpec {
    public static byte[] encode(DeviceListMetadata protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)DeviceListMetadataSpec.sizeOf(protoInputObject));
        DeviceListMetadataSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(DeviceListMetadata protoInputObject, ProtobufOutputStream protoOutputStream) {
        Long recipientTimestamp;
        ByteBuffer recipientKeyHash0;
        Long senderTimestamp;
        ByteBuffer senderKeyHash0;
        if (protoInputObject == null) {
            return;
        }
        byte[] senderKeyHash = protoInputObject.senderKeyHash();
        if (senderKeyHash != null && (senderKeyHash0 = ProtobufLazyMixin.toValue((byte[])senderKeyHash)) != null) {
            protoOutputStream.writeBytes(1, senderKeyHash0);
        }
        if ((senderTimestamp = protoInputObject.senderTimestamp()) != null) {
            protoOutputStream.writeUInt64(2, senderTimestamp);
        }
        protoOutputStream.writeUInt32Packed(3, protoInputObject.senderKeyIndexes());
        byte[] recipientKeyHash = protoInputObject.recipientKeyHash();
        if (recipientKeyHash != null && (recipientKeyHash0 = ProtobufLazyMixin.toValue((byte[])recipientKeyHash)) != null) {
            protoOutputStream.writeBytes(8, recipientKeyHash0);
        }
        if ((recipientTimestamp = protoInputObject.recipientTimestamp()) != null) {
            protoOutputStream.writeUInt64(9, recipientTimestamp);
        }
        protoOutputStream.writeUInt32Packed(10, protoInputObject.recipientKeyIndexes());
    }

    public static DeviceListMetadata decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return DeviceListMetadataSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static DeviceListMetadata decode(ProtobufInputStream protoInputStream) {
        byte[] senderKeyHash = null;
        Long senderTimestamp = null;
        List senderKeyIndexes = ProtobufRepeatedMixin.newList();
        byte[] recipientKeyHash = null;
        Long recipientTimestamp = null;
        List recipientKeyIndexes = ProtobufRepeatedMixin.newList();
        block8: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    senderKeyHash = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block8;
                }
                case 2: {
                    senderTimestamp = protoInputStream.readInt64();
                    continue block8;
                }
                case 3: {
                    senderKeyIndexes.addAll(protoInputStream.readInt32Packed());
                    continue block8;
                }
                case 8: {
                    recipientKeyHash = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block8;
                }
                case 9: {
                    recipientTimestamp = protoInputStream.readInt64();
                    continue block8;
                }
                case 10: {
                    recipientKeyIndexes.addAll(protoInputStream.readInt32Packed());
                    continue block8;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new DeviceListMetadata(senderKeyHash, senderTimestamp, senderKeyIndexes, recipientKeyHash, recipientTimestamp, recipientKeyIndexes);
    }

    public static int sizeOf(DeviceListMetadata protoInputObject) {
        Long recipientTimestamp;
        ByteBuffer recipientKeyHash0;
        Long senderTimestamp;
        ByteBuffer senderKeyHash0;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        byte[] senderKeyHash = protoInputObject.senderKeyHash();
        if (senderKeyHash != null && (senderKeyHash0 = ProtobufLazyMixin.toValue((byte[])senderKeyHash)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)senderKeyHash0);
        }
        if ((senderTimestamp = protoInputObject.senderTimestamp()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)senderTimestamp);
        }
        protoOutputSize += ProtobufOutputStream.getVarIntPackedSize((int)3, protoInputObject.senderKeyIndexes());
        byte[] recipientKeyHash = protoInputObject.recipientKeyHash();
        if (recipientKeyHash != null && (recipientKeyHash0 = ProtobufLazyMixin.toValue((byte[])recipientKeyHash)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)8, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)recipientKeyHash0);
        }
        if ((recipientTimestamp = protoInputObject.recipientTimestamp()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)9, (int)0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)recipientTimestamp);
        }
        return protoOutputSize += ProtobufOutputStream.getVarIntPackedSize((int)10, protoInputObject.recipientKeyIndexes());
    }
}

