/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.builtin.ProtobufRepeatedMixin;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.GroupPastParticipants;
import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.whatsapp.model.setting.GlobalSettings;
import it.auties.whatsapp.model.sync.HistorySync;
import it.auties.whatsapp.model.sync.PushName;
import it.auties.whatsapp.model.sync.StickerMetadata;
import java.nio.ByteBuffer;
import java.util.List;

public class HistorySyncBuilder {
    private HistorySync.Type syncType = null;
    private List<Chat> conversations = ProtobufRepeatedMixin.newList();
    private List<ChatMessageInfo> statusV3Messages = ProtobufRepeatedMixin.newList();
    private int chunkOrder = 0;
    private Integer progress = null;
    private List<PushName> pushNames = ProtobufRepeatedMixin.newList();
    private GlobalSettings globalSettings = null;
    private byte[] threadIdUserSecret = null;
    private int threadDsTimeframeOffset = 0;
    private List<StickerMetadata> recentStickers = ProtobufRepeatedMixin.newList();
    private List<GroupPastParticipants> pastParticipants = ProtobufRepeatedMixin.newList();

    public HistorySyncBuilder syncType(HistorySync.Type syncType) {
        this.syncType = syncType;
        return this;
    }

    public HistorySyncBuilder conversations(List<Chat> conversations) {
        this.conversations = conversations;
        return this;
    }

    public HistorySyncBuilder statusV3Messages(List<ChatMessageInfo> statusV3Messages) {
        this.statusV3Messages = statusV3Messages;
        return this;
    }

    public HistorySyncBuilder chunkOrder(int chunkOrder) {
        this.chunkOrder = chunkOrder;
        return this;
    }

    public HistorySyncBuilder progress(Integer progress) {
        this.progress = progress;
        return this;
    }

    public HistorySyncBuilder pushNames(List<PushName> pushNames) {
        this.pushNames = pushNames;
        return this;
    }

    public HistorySyncBuilder globalSettings(GlobalSettings globalSettings) {
        this.globalSettings = globalSettings;
        return this;
    }

    public HistorySyncBuilder threadIdUserSecret(ByteBuffer threadIdUserSecret) {
        this.threadIdUserSecret = ProtobufLazyMixin.ofNullable((ByteBuffer)threadIdUserSecret);
        return this;
    }

    public HistorySyncBuilder threadIdUserSecret(byte[] threadIdUserSecret) {
        this.threadIdUserSecret = threadIdUserSecret;
        return this;
    }

    public HistorySyncBuilder threadDsTimeframeOffset(int threadDsTimeframeOffset) {
        this.threadDsTimeframeOffset = threadDsTimeframeOffset;
        return this;
    }

    public HistorySyncBuilder recentStickers(List<StickerMetadata> recentStickers) {
        this.recentStickers = recentStickers;
        return this;
    }

    public HistorySyncBuilder pastParticipants(List<GroupPastParticipants> pastParticipants) {
        this.pastParticipants = pastParticipants;
        return this;
    }

    public HistorySync build() {
        return new HistorySync(this.syncType, this.conversations, this.statusV3Messages, this.chunkOrder, this.progress, this.pushNames, this.globalSettings, this.threadIdUserSecret, this.threadDsTimeframeOffset, this.recentStickers, this.pastParticipants);
    }
}

