/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.sync.HistorySyncConfig;

public class HistorySyncConfigSpec {
    public static byte[] encode(HistorySyncConfig protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)HistorySyncConfigSpec.sizeOf(protoInputObject));
        HistorySyncConfigSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(HistorySyncConfig protoInputObject, ProtobufOutputStream protoOutputStream) {
        Boolean supportBotUserAgentChatHistory;
        Boolean supportCallLogHistory;
        Integer recentSyncDaysLimit;
        Boolean inlineInitialPayloadInE2EeMsg;
        Integer storageQuotaMb;
        Integer fullSyncSizeMbLimit;
        if (protoInputObject == null) {
            return;
        }
        Integer fullSyncDaysLimit = protoInputObject.fullSyncDaysLimit();
        if (fullSyncDaysLimit != null) {
            protoOutputStream.writeUInt32(1, fullSyncDaysLimit);
        }
        if ((fullSyncSizeMbLimit = protoInputObject.fullSyncSizeMbLimit()) != null) {
            protoOutputStream.writeUInt32(2, fullSyncSizeMbLimit);
        }
        if ((storageQuotaMb = protoInputObject.storageQuotaMb()) != null) {
            protoOutputStream.writeUInt32(3, storageQuotaMb);
        }
        if ((inlineInitialPayloadInE2EeMsg = protoInputObject.inlineInitialPayloadInE2EeMsg()) != null) {
            protoOutputStream.writeBool(4, inlineInitialPayloadInE2EeMsg);
        }
        if ((recentSyncDaysLimit = protoInputObject.recentSyncDaysLimit()) != null) {
            protoOutputStream.writeUInt32(5, recentSyncDaysLimit);
        }
        if ((supportCallLogHistory = protoInputObject.supportCallLogHistory()) != null) {
            protoOutputStream.writeBool(6, supportCallLogHistory);
        }
        if ((supportBotUserAgentChatHistory = protoInputObject.supportBotUserAgentChatHistory()) != null) {
            protoOutputStream.writeBool(7, supportBotUserAgentChatHistory);
        }
    }

    public static HistorySyncConfig decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return HistorySyncConfigSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static HistorySyncConfig decode(ProtobufInputStream protoInputStream) {
        Integer fullSyncDaysLimit = null;
        Integer fullSyncSizeMbLimit = null;
        Integer storageQuotaMb = null;
        Boolean inlineInitialPayloadInE2EeMsg = null;
        Integer recentSyncDaysLimit = null;
        Boolean supportCallLogHistory = null;
        Boolean supportBotUserAgentChatHistory = null;
        block9: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    fullSyncDaysLimit = protoInputStream.readInt32();
                    continue block9;
                }
                case 2: {
                    fullSyncSizeMbLimit = protoInputStream.readInt32();
                    continue block9;
                }
                case 3: {
                    storageQuotaMb = protoInputStream.readInt32();
                    continue block9;
                }
                case 4: {
                    inlineInitialPayloadInE2EeMsg = protoInputStream.readBool();
                    continue block9;
                }
                case 5: {
                    recentSyncDaysLimit = protoInputStream.readInt32();
                    continue block9;
                }
                case 6: {
                    supportCallLogHistory = protoInputStream.readBool();
                    continue block9;
                }
                case 7: {
                    supportBotUserAgentChatHistory = protoInputStream.readBool();
                    continue block9;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new HistorySyncConfig(fullSyncDaysLimit, fullSyncSizeMbLimit, storageQuotaMb, inlineInitialPayloadInE2EeMsg, recentSyncDaysLimit, supportCallLogHistory, supportBotUserAgentChatHistory);
    }

    public static int sizeOf(HistorySyncConfig protoInputObject) {
        Boolean supportBotUserAgentChatHistory;
        Boolean supportCallLogHistory;
        Integer recentSyncDaysLimit;
        Boolean inlineInitialPayloadInE2EeMsg;
        Integer storageQuotaMb;
        Integer fullSyncSizeMbLimit;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        Integer fullSyncDaysLimit = protoInputObject.fullSyncDaysLimit();
        if (fullSyncDaysLimit != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)fullSyncDaysLimit.intValue());
        }
        if ((fullSyncSizeMbLimit = protoInputObject.fullSyncSizeMbLimit()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)fullSyncSizeMbLimit.intValue());
        }
        if ((storageQuotaMb = protoInputObject.storageQuotaMb()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)storageQuotaMb.intValue());
        }
        if ((inlineInitialPayloadInE2EeMsg = protoInputObject.inlineInitialPayloadInE2EeMsg()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)0);
            ++protoOutputSize;
        }
        if ((recentSyncDaysLimit = protoInputObject.recentSyncDaysLimit()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)5, (int)0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)recentSyncDaysLimit.intValue());
        }
        if ((supportCallLogHistory = protoInputObject.supportCallLogHistory()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)6, (int)0);
            ++protoOutputSize;
        }
        if ((supportBotUserAgentChatHistory = protoInputObject.supportBotUserAgentChatHistory()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)7, (int)0);
            ++protoOutputSize;
        }
        return protoOutputSize;
    }
}

