/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.whatsapp.model.info.ChatMessageInfoSpec;
import it.auties.whatsapp.model.sync.HistorySyncMessage;

public class HistorySyncMessageSpec {
    public static byte[] encode(HistorySyncMessage protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)HistorySyncMessageSpec.sizeOf(protoInputObject));
        HistorySyncMessageSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(HistorySyncMessage protoInputObject, ProtobufOutputStream protoOutputStream) {
        if (protoInputObject == null) {
            return;
        }
        ChatMessageInfo messageInfo = protoInputObject.messageInfo();
        if (messageInfo != null) {
            protoOutputStream.writeMessage(1, ChatMessageInfoSpec.sizeOf(messageInfo));
            ChatMessageInfoSpec.encode(messageInfo, protoOutputStream);
        }
        long messageOrderId = protoInputObject.messageOrderId();
        protoOutputStream.writeUInt64(2, Long.valueOf(messageOrderId));
    }

    public static HistorySyncMessage decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return HistorySyncMessageSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static HistorySyncMessage decode(ProtobufInputStream protoInputStream) {
        ChatMessageInfo messageInfo = null;
        long messageOrderId = 0L;
        block4: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    messageInfo = ChatMessageInfoSpec.decode(protoInputStream.readLengthDelimited());
                    continue block4;
                }
                case 2: {
                    messageOrderId = protoInputStream.readInt64();
                    continue block4;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new HistorySyncMessage(messageInfo, messageOrderId);
    }

    public static int sizeOf(HistorySyncMessage protoInputObject) {
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        ChatMessageInfo messageInfo = protoInputObject.messageInfo();
        if (messageInfo != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            int messageInfoSerializedSize = ChatMessageInfoSpec.sizeOf(messageInfo);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)messageInfoSerializedSize);
            protoOutputSize += messageInfoSerializedSize;
        }
        long messageOrderId = protoInputObject.messageOrderId();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)0);
        return protoOutputSize += ProtobufOutputStream.getVarIntSize((long)messageOrderId);
    }
}

