/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.builtin.ProtobufOptionalMixin;
import it.auties.protobuf.model.ProtobufString;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.sync.HistorySync;
import it.auties.whatsapp.model.sync.HistorySyncNotification;
import it.auties.whatsapp.model.sync.HistorySyncTypeSpec;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.OptionalLong;

public class HistorySyncNotificationSpec {
    public static byte[] encode(HistorySyncNotification protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)HistorySyncNotificationSpec.sizeOf(protoInputObject));
        HistorySyncNotificationSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(HistorySyncNotification protoInputObject, ProtobufOutputStream protoOutputStream) {
        ProtobufString peerDataRequestSessionId1;
        String peerDataRequestSessionId0;
        Optional<String> peerDataRequestSessionId;
        ByteBuffer initialHistBootstrapInlinePayload1;
        byte[] initialHistBootstrapInlinePayload0;
        Integer progress;
        ProtobufString originalMessageId1;
        String originalMessageId0;
        Optional<String> originalMessageId;
        Integer chunkOrder;
        HistorySync.Type syncType;
        ProtobufString mediaDirectPath1;
        String mediaDirectPath0;
        Optional<String> mediaDirectPath;
        ByteBuffer mediaEncryptedSha2561;
        byte[] mediaEncryptedSha2560;
        Optional<byte[]> mediaEncryptedSha256;
        ByteBuffer mediaKey1;
        byte[] mediaKey0;
        Optional<byte[]> mediaKey;
        Long mediaSize0;
        OptionalLong mediaSize;
        ByteBuffer mediaSha2561;
        byte[] mediaSha2560;
        if (protoInputObject == null) {
            return;
        }
        Optional<byte[]> mediaSha256 = protoInputObject.mediaSha256();
        if (mediaSha256 != null && (mediaSha2560 = (byte[])ProtobufOptionalMixin.toNullableValue(mediaSha256)) != null && (mediaSha2561 = ProtobufLazyMixin.toValue((byte[])mediaSha2560)) != null) {
            protoOutputStream.writeBytes(1, mediaSha2561);
        }
        if ((mediaSize = protoInputObject.mediaSize()) != null && (mediaSize0 = ProtobufOptionalMixin.toNullableLong((OptionalLong)mediaSize)) != null) {
            protoOutputStream.writeUInt64(2, mediaSize0);
        }
        if ((mediaKey = protoInputObject.mediaKey()) != null && (mediaKey0 = (byte[])ProtobufOptionalMixin.toNullableValue(mediaKey)) != null && (mediaKey1 = ProtobufLazyMixin.toValue((byte[])mediaKey0)) != null) {
            protoOutputStream.writeBytes(3, mediaKey1);
        }
        if ((mediaEncryptedSha256 = protoInputObject.mediaEncryptedSha256()) != null && (mediaEncryptedSha2560 = (byte[])ProtobufOptionalMixin.toNullableValue(mediaEncryptedSha256)) != null && (mediaEncryptedSha2561 = ProtobufLazyMixin.toValue((byte[])mediaEncryptedSha2560)) != null) {
            protoOutputStream.writeBytes(4, mediaEncryptedSha2561);
        }
        if ((mediaDirectPath = protoInputObject.mediaDirectPath()) != null && (mediaDirectPath0 = (String)ProtobufOptionalMixin.toNullableValue(mediaDirectPath)) != null && (mediaDirectPath1 = ProtobufLazyMixin.toValue((String)mediaDirectPath0)) != null) {
            protoOutputStream.writeString(5, mediaDirectPath1);
        }
        if ((syncType = protoInputObject.syncType()) != null) {
            Integer syncType0 = HistorySyncTypeSpec.encode(syncType);
            protoOutputStream.writeInt32(6, syncType0);
        }
        if ((chunkOrder = protoInputObject.chunkOrder()) != null) {
            protoOutputStream.writeUInt32(7, chunkOrder);
        }
        if ((originalMessageId = protoInputObject.originalMessageId()) != null && (originalMessageId0 = (String)ProtobufOptionalMixin.toNullableValue(originalMessageId)) != null && (originalMessageId1 = ProtobufLazyMixin.toValue((String)originalMessageId0)) != null) {
            protoOutputStream.writeString(8, originalMessageId1);
        }
        if ((progress = protoInputObject.progress()) != null) {
            protoOutputStream.writeUInt32(9, progress);
        }
        long oldestMsgInChunkTimestampSec = protoInputObject.oldestMsgInChunkTimestampSec();
        protoOutputStream.writeInt64(10, Long.valueOf(oldestMsgInChunkTimestampSec));
        Optional<byte[]> initialHistBootstrapInlinePayload = protoInputObject.initialHistBootstrapInlinePayload();
        if (initialHistBootstrapInlinePayload != null && (initialHistBootstrapInlinePayload0 = (byte[])ProtobufOptionalMixin.toNullableValue(initialHistBootstrapInlinePayload)) != null && (initialHistBootstrapInlinePayload1 = ProtobufLazyMixin.toValue((byte[])initialHistBootstrapInlinePayload0)) != null) {
            protoOutputStream.writeBytes(11, initialHistBootstrapInlinePayload1);
        }
        if ((peerDataRequestSessionId = protoInputObject.peerDataRequestSessionId()) != null && (peerDataRequestSessionId0 = (String)ProtobufOptionalMixin.toNullableValue(peerDataRequestSessionId)) != null && (peerDataRequestSessionId1 = ProtobufLazyMixin.toValue((String)peerDataRequestSessionId0)) != null) {
            protoOutputStream.writeString(12, peerDataRequestSessionId1);
        }
    }

    public static HistorySyncNotification decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return HistorySyncNotificationSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static HistorySyncNotification decode(ProtobufInputStream protoInputStream) {
        byte[] mediaSha256 = null;
        Long mediaSize = null;
        byte[] mediaKey = null;
        byte[] mediaEncryptedSha256 = null;
        String mediaDirectPath = null;
        HistorySync.Type syncType = null;
        Integer chunkOrder = null;
        String originalMessageId = null;
        Integer progress = null;
        long oldestMsgInChunkTimestampSec = 0L;
        byte[] initialHistBootstrapInlinePayload = null;
        String peerDataRequestSessionId = null;
        block14: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    mediaSha256 = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block14;
                }
                case 2: {
                    mediaSize = protoInputStream.readInt64();
                    continue block14;
                }
                case 3: {
                    mediaKey = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block14;
                }
                case 4: {
                    mediaEncryptedSha256 = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block14;
                }
                case 5: {
                    mediaDirectPath = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block14;
                }
                case 6: {
                    syncType = HistorySyncTypeSpec.decode(protoInputStream.readInt32());
                    continue block14;
                }
                case 7: {
                    chunkOrder = protoInputStream.readInt32();
                    continue block14;
                }
                case 8: {
                    originalMessageId = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block14;
                }
                case 9: {
                    progress = protoInputStream.readInt32();
                    continue block14;
                }
                case 10: {
                    oldestMsgInChunkTimestampSec = protoInputStream.readInt64();
                    continue block14;
                }
                case 11: {
                    initialHistBootstrapInlinePayload = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block14;
                }
                case 12: {
                    peerDataRequestSessionId = ProtobufLazyMixin.ofNullable((ProtobufString)protoInputStream.readString());
                    continue block14;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new HistorySyncNotification(mediaSha256, mediaSize, mediaKey, mediaEncryptedSha256, mediaDirectPath, syncType, chunkOrder, originalMessageId, progress, oldestMsgInChunkTimestampSec, initialHistBootstrapInlinePayload, peerDataRequestSessionId);
    }

    public static int sizeOf(HistorySyncNotification protoInputObject) {
        ProtobufString peerDataRequestSessionId1;
        String peerDataRequestSessionId0;
        Optional<String> peerDataRequestSessionId;
        ByteBuffer initialHistBootstrapInlinePayload1;
        byte[] initialHistBootstrapInlinePayload0;
        Integer progress;
        ProtobufString originalMessageId1;
        String originalMessageId0;
        Optional<String> originalMessageId;
        Integer chunkOrder;
        HistorySync.Type syncType;
        ProtobufString mediaDirectPath1;
        String mediaDirectPath0;
        Optional<String> mediaDirectPath;
        ByteBuffer mediaEncryptedSha2561;
        byte[] mediaEncryptedSha2560;
        Optional<byte[]> mediaEncryptedSha256;
        ByteBuffer mediaKey1;
        byte[] mediaKey0;
        Optional<byte[]> mediaKey;
        Long mediaSize0;
        OptionalLong mediaSize;
        ByteBuffer mediaSha2561;
        byte[] mediaSha2560;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        Optional<byte[]> mediaSha256 = protoInputObject.mediaSha256();
        if (mediaSha256 != null && (mediaSha2560 = (byte[])ProtobufOptionalMixin.toNullableValue(mediaSha256)) != null && (mediaSha2561 = ProtobufLazyMixin.toValue((byte[])mediaSha2560)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)mediaSha2561);
        }
        if ((mediaSize = protoInputObject.mediaSize()) != null && (mediaSize0 = ProtobufOptionalMixin.toNullableLong((OptionalLong)mediaSize)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)mediaSize0);
        }
        if ((mediaKey = protoInputObject.mediaKey()) != null && (mediaKey0 = (byte[])ProtobufOptionalMixin.toNullableValue(mediaKey)) != null && (mediaKey1 = ProtobufLazyMixin.toValue((byte[])mediaKey0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)mediaKey1);
        }
        if ((mediaEncryptedSha256 = protoInputObject.mediaEncryptedSha256()) != null && (mediaEncryptedSha2560 = (byte[])ProtobufOptionalMixin.toNullableValue(mediaEncryptedSha256)) != null && (mediaEncryptedSha2561 = ProtobufLazyMixin.toValue((byte[])mediaEncryptedSha2560)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)mediaEncryptedSha2561);
        }
        if ((mediaDirectPath = protoInputObject.mediaDirectPath()) != null && (mediaDirectPath0 = (String)ProtobufOptionalMixin.toNullableValue(mediaDirectPath)) != null && (mediaDirectPath1 = ProtobufLazyMixin.toValue((String)mediaDirectPath0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)5, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)mediaDirectPath1);
        }
        if ((syncType = protoInputObject.syncType()) != null) {
            Integer syncType0 = HistorySyncTypeSpec.encode(syncType);
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)6, (int)2);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)syncType0.intValue());
        }
        if ((chunkOrder = protoInputObject.chunkOrder()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)7, (int)0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)chunkOrder.intValue());
        }
        if ((originalMessageId = protoInputObject.originalMessageId()) != null && (originalMessageId0 = (String)ProtobufOptionalMixin.toNullableValue(originalMessageId)) != null && (originalMessageId1 = ProtobufLazyMixin.toValue((String)originalMessageId0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)8, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)originalMessageId1);
        }
        if ((progress = protoInputObject.progress()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)9, (int)0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)progress.intValue());
        }
        long oldestMsgInChunkTimestampSec = protoInputObject.oldestMsgInChunkTimestampSec();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)10, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)oldestMsgInChunkTimestampSec);
        Optional<byte[]> initialHistBootstrapInlinePayload = protoInputObject.initialHistBootstrapInlinePayload();
        if (initialHistBootstrapInlinePayload != null && (initialHistBootstrapInlinePayload0 = (byte[])ProtobufOptionalMixin.toNullableValue(initialHistBootstrapInlinePayload)) != null && (initialHistBootstrapInlinePayload1 = ProtobufLazyMixin.toValue((byte[])initialHistBootstrapInlinePayload0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)11, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)initialHistBootstrapInlinePayload1);
        }
        if ((peerDataRequestSessionId = protoInputObject.peerDataRequestSessionId()) != null && (peerDataRequestSessionId0 = (String)ProtobufOptionalMixin.toNullableValue(peerDataRequestSessionId)) != null && (peerDataRequestSessionId1 = ProtobufLazyMixin.toValue((String)peerDataRequestSessionId0)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)12, (int)2);
            protoOutputSize += ProtobufOutputStream.getStringSize((ProtobufString)peerDataRequestSessionId1);
        }
        return protoOutputSize;
    }
}

