/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.builtin.ProtobufRepeatedMixin;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.chat.Chat;
import it.auties.whatsapp.model.chat.ChatSpec;
import it.auties.whatsapp.model.chat.GroupPastParticipants;
import it.auties.whatsapp.model.chat.GroupPastParticipantsSpec;
import it.auties.whatsapp.model.info.ChatMessageInfo;
import it.auties.whatsapp.model.info.ChatMessageInfoSpec;
import it.auties.whatsapp.model.setting.GlobalSettings;
import it.auties.whatsapp.model.setting.GlobalSettingsSpec;
import it.auties.whatsapp.model.sync.HistorySync;
import it.auties.whatsapp.model.sync.HistorySyncTypeSpec;
import it.auties.whatsapp.model.sync.PushName;
import it.auties.whatsapp.model.sync.PushNameSpec;
import it.auties.whatsapp.model.sync.StickerMetadata;
import it.auties.whatsapp.model.sync.StickerMetadataSpec;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class HistorySyncSpec {
    public static byte[] encode(HistorySync protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)HistorySyncSpec.sizeOf(protoInputObject));
        HistorySyncSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(HistorySync protoInputObject, ProtobufOutputStream protoOutputStream) {
        ByteBuffer threadIdUserSecret0;
        byte[] threadIdUserSecret;
        GlobalSettings globalSettings;
        if (protoInputObject == null) {
            return;
        }
        Objects.requireNonNull(protoInputObject.syncType(), "Missing required property: syncType");
        HistorySync.Type syncType = protoInputObject.syncType();
        if (syncType != null) {
            Iterator<ChatMessageInfo> syncType0 = HistorySyncTypeSpec.encode(syncType);
            protoOutputStream.writeInt32(1, (Integer)((Object)syncType0));
        }
        if (protoInputObject.conversations() != null) {
            for (Chat conversationsEntry : protoInputObject.conversations()) {
                if (conversationsEntry == null) continue;
                protoOutputStream.writeMessage(2, ChatSpec.sizeOf(conversationsEntry));
                ChatSpec.encode(conversationsEntry, protoOutputStream);
            }
        }
        if (protoInputObject.statusV3Messages() != null) {
            for (ChatMessageInfo statusV3MessagesEntry : protoInputObject.statusV3Messages()) {
                if (statusV3MessagesEntry == null) continue;
                protoOutputStream.writeMessage(3, ChatMessageInfoSpec.sizeOf(statusV3MessagesEntry));
                ChatMessageInfoSpec.encode(statusV3MessagesEntry, protoOutputStream);
            }
        }
        int chunkOrder = protoInputObject.chunkOrder();
        protoOutputStream.writeUInt32(5, Integer.valueOf(chunkOrder));
        Integer progress = protoInputObject.progress();
        if (progress != null) {
            protoOutputStream.writeUInt32(6, progress);
        }
        if (protoInputObject.pushNames() != null) {
            for (PushName pushNamesEntry : protoInputObject.pushNames()) {
                if (pushNamesEntry == null) continue;
                protoOutputStream.writeMessage(7, PushNameSpec.sizeOf(pushNamesEntry));
                PushNameSpec.encode(pushNamesEntry, protoOutputStream);
            }
        }
        if ((globalSettings = protoInputObject.globalSettings()) != null) {
            protoOutputStream.writeMessage(8, GlobalSettingsSpec.sizeOf(globalSettings));
            GlobalSettingsSpec.encode(globalSettings, protoOutputStream);
        }
        if ((threadIdUserSecret = protoInputObject.threadIdUserSecret()) != null && (threadIdUserSecret0 = ProtobufLazyMixin.toValue((byte[])threadIdUserSecret)) != null) {
            protoOutputStream.writeBytes(9, threadIdUserSecret0);
        }
        int threadDsTimeframeOffset = protoInputObject.threadDsTimeframeOffset();
        protoOutputStream.writeUInt32(10, Integer.valueOf(threadDsTimeframeOffset));
        if (protoInputObject.recentStickers() != null) {
            for (StickerMetadata recentStickersEntry : protoInputObject.recentStickers()) {
                if (recentStickersEntry == null) continue;
                protoOutputStream.writeMessage(11, StickerMetadataSpec.sizeOf(recentStickersEntry));
                StickerMetadataSpec.encode(recentStickersEntry, protoOutputStream);
            }
        }
        if (protoInputObject.pastParticipants() != null) {
            for (GroupPastParticipants pastParticipantsEntry : protoInputObject.pastParticipants()) {
                if (pastParticipantsEntry == null) continue;
                protoOutputStream.writeMessage(12, GroupPastParticipantsSpec.sizeOf(pastParticipantsEntry));
                GroupPastParticipantsSpec.encode(pastParticipantsEntry, protoOutputStream);
            }
        }
    }

    public static HistorySync decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return HistorySyncSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static HistorySync decode(ProtobufInputStream protoInputStream) {
        HistorySync.Type syncType = null;
        List conversations = ProtobufRepeatedMixin.newList();
        List statusV3Messages = ProtobufRepeatedMixin.newList();
        int chunkOrder = 0;
        Integer progress = null;
        List pushNames = ProtobufRepeatedMixin.newList();
        GlobalSettings globalSettings = null;
        byte[] threadIdUserSecret = null;
        int threadDsTimeframeOffset = 0;
        List recentStickers = ProtobufRepeatedMixin.newList();
        List pastParticipants = ProtobufRepeatedMixin.newList();
        block13: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    syncType = HistorySyncTypeSpec.decode(protoInputStream.readInt32());
                    continue block13;
                }
                case 2: {
                    conversations.add(ChatSpec.decode(protoInputStream.readLengthDelimited()));
                    continue block13;
                }
                case 3: {
                    statusV3Messages.add(ChatMessageInfoSpec.decode(protoInputStream.readLengthDelimited()));
                    continue block13;
                }
                case 5: {
                    chunkOrder = protoInputStream.readInt32();
                    continue block13;
                }
                case 6: {
                    progress = protoInputStream.readInt32();
                    continue block13;
                }
                case 7: {
                    pushNames.add(PushNameSpec.decode(protoInputStream.readLengthDelimited()));
                    continue block13;
                }
                case 8: {
                    globalSettings = GlobalSettingsSpec.decode(protoInputStream.readLengthDelimited());
                    continue block13;
                }
                case 9: {
                    threadIdUserSecret = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block13;
                }
                case 10: {
                    threadDsTimeframeOffset = protoInputStream.readInt32();
                    continue block13;
                }
                case 11: {
                    recentStickers.add(StickerMetadataSpec.decode(protoInputStream.readLengthDelimited()));
                    continue block13;
                }
                case 12: {
                    pastParticipants.add(GroupPastParticipantsSpec.decode(protoInputStream.readLengthDelimited()));
                    continue block13;
                }
            }
            protoInputStream.readUnknown(false);
        }
        Objects.requireNonNull(syncType, "Missing required property: syncType");
        return new HistorySync(syncType, conversations, statusV3Messages, chunkOrder, progress, pushNames, globalSettings, threadIdUserSecret, threadDsTimeframeOffset, recentStickers, pastParticipants);
    }

    public static int sizeOf(HistorySync protoInputObject) {
        ByteBuffer threadIdUserSecret0;
        byte[] threadIdUserSecret;
        GlobalSettings globalSettings;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        HistorySync.Type syncType = protoInputObject.syncType();
        if (syncType != null) {
            Iterator<ChatMessageInfo> syncType0 = HistorySyncTypeSpec.encode(syncType);
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)((Integer)((Object)syncType0)).intValue());
        }
        if (protoInputObject.conversations() != null) {
            for (Chat conversationsEntry : protoInputObject.conversations()) {
                if (conversationsEntry == null) continue;
                protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
                int conversationsEntrySerializedSize = ChatSpec.sizeOf(conversationsEntry);
                protoOutputSize += ProtobufOutputStream.getVarIntSize((long)conversationsEntrySerializedSize);
                protoOutputSize += conversationsEntrySerializedSize;
            }
        }
        if (protoInputObject.statusV3Messages() != null) {
            for (ChatMessageInfo statusV3MessagesEntry : protoInputObject.statusV3Messages()) {
                if (statusV3MessagesEntry == null) continue;
                protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)2);
                int statusV3MessagesEntrySerializedSize = ChatMessageInfoSpec.sizeOf(statusV3MessagesEntry);
                protoOutputSize += ProtobufOutputStream.getVarIntSize((long)statusV3MessagesEntrySerializedSize);
                protoOutputSize += statusV3MessagesEntrySerializedSize;
            }
        }
        int chunkOrder = protoInputObject.chunkOrder();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)5, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)chunkOrder);
        Integer progress = protoInputObject.progress();
        if (progress != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)6, (int)0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)progress.intValue());
        }
        if (protoInputObject.pushNames() != null) {
            for (PushName pushNamesEntry : protoInputObject.pushNames()) {
                if (pushNamesEntry == null) continue;
                protoOutputSize += ProtobufOutputStream.getFieldSize((int)7, (int)2);
                int pushNamesEntrySerializedSize = PushNameSpec.sizeOf(pushNamesEntry);
                protoOutputSize += ProtobufOutputStream.getVarIntSize((long)pushNamesEntrySerializedSize);
                protoOutputSize += pushNamesEntrySerializedSize;
            }
        }
        if ((globalSettings = protoInputObject.globalSettings()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)8, (int)2);
            int globalSettingsSerializedSize = GlobalSettingsSpec.sizeOf(globalSettings);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)globalSettingsSerializedSize);
            protoOutputSize += globalSettingsSerializedSize;
        }
        if ((threadIdUserSecret = protoInputObject.threadIdUserSecret()) != null && (threadIdUserSecret0 = ProtobufLazyMixin.toValue((byte[])threadIdUserSecret)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)9, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)threadIdUserSecret0);
        }
        int threadDsTimeframeOffset = protoInputObject.threadDsTimeframeOffset();
        protoOutputSize += ProtobufOutputStream.getFieldSize((int)10, (int)0);
        protoOutputSize += ProtobufOutputStream.getVarIntSize((long)threadDsTimeframeOffset);
        if (protoInputObject.recentStickers() != null) {
            for (StickerMetadata recentStickersEntry : protoInputObject.recentStickers()) {
                if (recentStickersEntry == null) continue;
                protoOutputSize += ProtobufOutputStream.getFieldSize((int)11, (int)2);
                int recentStickersEntrySerializedSize = StickerMetadataSpec.sizeOf(recentStickersEntry);
                protoOutputSize += ProtobufOutputStream.getVarIntSize((long)recentStickersEntrySerializedSize);
                protoOutputSize += recentStickersEntrySerializedSize;
            }
        }
        if (protoInputObject.pastParticipants() != null) {
            for (GroupPastParticipants pastParticipantsEntry : protoInputObject.pastParticipants()) {
                if (pastParticipantsEntry == null) continue;
                protoOutputSize += ProtobufOutputStream.getFieldSize((int)12, (int)2);
                int pastParticipantsEntrySerializedSize = GroupPastParticipantsSpec.sizeOf(pastParticipantsEntry);
                protoOutputSize += ProtobufOutputStream.getVarIntSize((long)pastParticipantsEntrySerializedSize);
                protoOutputSize += pastParticipantsEntrySerializedSize;
            }
        }
        return protoOutputSize;
    }
}

