/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.sync;

import it.auties.protobuf.builtin.ProtobufLazyMixin;
import it.auties.protobuf.builtin.ProtobufRepeatedMixin;
import it.auties.protobuf.stream.ProtobufInputStream;
import it.auties.protobuf.stream.ProtobufOutputStream;
import it.auties.whatsapp.model.sync.ExitCode;
import it.auties.whatsapp.model.sync.ExitCodeSpec;
import it.auties.whatsapp.model.sync.ExternalBlobReference;
import it.auties.whatsapp.model.sync.ExternalBlobReferenceSpec;
import it.auties.whatsapp.model.sync.KeyId;
import it.auties.whatsapp.model.sync.KeyIdSpec;
import it.auties.whatsapp.model.sync.MutationSync;
import it.auties.whatsapp.model.sync.MutationSyncSpec;
import it.auties.whatsapp.model.sync.PatchSync;
import it.auties.whatsapp.model.sync.VersionSync;
import it.auties.whatsapp.model.sync.VersionSyncSpec;
import java.nio.ByteBuffer;
import java.util.List;

public class PatchSyncSpec {
    public static byte[] encode(PatchSync protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        ProtobufOutputStream stream = ProtobufOutputStream.toBytes((int)PatchSyncSpec.sizeOf(protoInputObject));
        PatchSyncSpec.encode(protoInputObject, stream);
        return (byte[])stream.toOutput();
    }

    public static void encode(PatchSync protoInputObject, ProtobufOutputStream protoOutputStream) {
        Integer deviceIndex;
        ExitCode exitCode;
        KeyId keyId;
        ByteBuffer patchMac0;
        byte[] patchMac;
        ByteBuffer snapshotMac0;
        byte[] snapshotMac;
        ExternalBlobReference externalMutations;
        if (protoInputObject == null) {
            return;
        }
        VersionSync version = protoInputObject.version();
        if (version != null) {
            protoOutputStream.writeMessage(1, VersionSyncSpec.sizeOf(version));
            VersionSyncSpec.encode(version, protoOutputStream);
        }
        if (protoInputObject.mutations() != null) {
            for (MutationSync mutationsEntry : protoInputObject.mutations()) {
                if (mutationsEntry == null) continue;
                protoOutputStream.writeMessage(2, MutationSyncSpec.sizeOf(mutationsEntry));
                MutationSyncSpec.encode(mutationsEntry, protoOutputStream);
            }
        }
        if ((externalMutations = protoInputObject.externalMutations()) != null) {
            protoOutputStream.writeMessage(3, ExternalBlobReferenceSpec.sizeOf(externalMutations));
            ExternalBlobReferenceSpec.encode(externalMutations, protoOutputStream);
        }
        if ((snapshotMac = protoInputObject.snapshotMac()) != null && (snapshotMac0 = ProtobufLazyMixin.toValue((byte[])snapshotMac)) != null) {
            protoOutputStream.writeBytes(4, snapshotMac0);
        }
        if ((patchMac = protoInputObject.patchMac()) != null && (patchMac0 = ProtobufLazyMixin.toValue((byte[])patchMac)) != null) {
            protoOutputStream.writeBytes(5, patchMac0);
        }
        if ((keyId = protoInputObject.keyId()) != null) {
            protoOutputStream.writeMessage(6, KeyIdSpec.sizeOf(keyId));
            KeyIdSpec.encode(keyId, protoOutputStream);
        }
        if ((exitCode = protoInputObject.exitCode()) != null) {
            protoOutputStream.writeMessage(7, ExitCodeSpec.sizeOf(exitCode));
            ExitCodeSpec.encode(exitCode, protoOutputStream);
        }
        if ((deviceIndex = protoInputObject.deviceIndex()) != null) {
            protoOutputStream.writeUInt32(8, deviceIndex);
        }
    }

    public static PatchSync decode(byte[] protoInputObject) {
        if (protoInputObject == null) {
            return null;
        }
        return PatchSyncSpec.decode(ProtobufInputStream.fromBytes((byte[])protoInputObject, (int)0, (int)protoInputObject.length));
    }

    public static PatchSync decode(ProtobufInputStream protoInputStream) {
        VersionSync version = null;
        List mutations = ProtobufRepeatedMixin.newList();
        ExternalBlobReference externalMutations = null;
        byte[] snapshotMac = null;
        byte[] patchMac = null;
        KeyId keyId = null;
        ExitCode exitCode = null;
        Integer deviceIndex = null;
        block10: while (protoInputStream.readTag()) {
            int protoFieldIndex = protoInputStream.index();
            switch (protoFieldIndex) {
                case 1: {
                    version = VersionSyncSpec.decode(protoInputStream.readLengthDelimited());
                    continue block10;
                }
                case 2: {
                    mutations.add(MutationSyncSpec.decode(protoInputStream.readLengthDelimited()));
                    continue block10;
                }
                case 3: {
                    externalMutations = ExternalBlobReferenceSpec.decode(protoInputStream.readLengthDelimited());
                    continue block10;
                }
                case 4: {
                    snapshotMac = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block10;
                }
                case 5: {
                    patchMac = ProtobufLazyMixin.ofNullable((ByteBuffer)protoInputStream.readBytes());
                    continue block10;
                }
                case 6: {
                    keyId = KeyIdSpec.decode(protoInputStream.readLengthDelimited());
                    continue block10;
                }
                case 7: {
                    exitCode = ExitCodeSpec.decode(protoInputStream.readLengthDelimited());
                    continue block10;
                }
                case 8: {
                    deviceIndex = protoInputStream.readInt32();
                    continue block10;
                }
            }
            protoInputStream.readUnknown(false);
        }
        return new PatchSync(version, mutations, externalMutations, snapshotMac, patchMac, keyId, exitCode, deviceIndex);
    }

    public static int sizeOf(PatchSync protoInputObject) {
        Integer deviceIndex;
        ExitCode exitCode;
        KeyId keyId;
        ByteBuffer patchMac0;
        byte[] patchMac;
        ByteBuffer snapshotMac0;
        byte[] snapshotMac;
        ExternalBlobReference externalMutations;
        if (protoInputObject == null) {
            return 0;
        }
        int protoOutputSize = 0;
        VersionSync version = protoInputObject.version();
        if (version != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)1, (int)2);
            int versionSerializedSize = VersionSyncSpec.sizeOf(version);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)versionSerializedSize);
            protoOutputSize += versionSerializedSize;
        }
        if (protoInputObject.mutations() != null) {
            for (MutationSync mutationsEntry : protoInputObject.mutations()) {
                if (mutationsEntry == null) continue;
                protoOutputSize += ProtobufOutputStream.getFieldSize((int)2, (int)2);
                int mutationsEntrySerializedSize = MutationSyncSpec.sizeOf(mutationsEntry);
                protoOutputSize += ProtobufOutputStream.getVarIntSize((long)mutationsEntrySerializedSize);
                protoOutputSize += mutationsEntrySerializedSize;
            }
        }
        if ((externalMutations = protoInputObject.externalMutations()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)3, (int)2);
            int externalMutationsSerializedSize = ExternalBlobReferenceSpec.sizeOf(externalMutations);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)externalMutationsSerializedSize);
            protoOutputSize += externalMutationsSerializedSize;
        }
        if ((snapshotMac = protoInputObject.snapshotMac()) != null && (snapshotMac0 = ProtobufLazyMixin.toValue((byte[])snapshotMac)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)4, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)snapshotMac0);
        }
        if ((patchMac = protoInputObject.patchMac()) != null && (patchMac0 = ProtobufLazyMixin.toValue((byte[])patchMac)) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)5, (int)2);
            protoOutputSize += ProtobufOutputStream.getBytesSize((ByteBuffer)patchMac0);
        }
        if ((keyId = protoInputObject.keyId()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)6, (int)2);
            int keyIdSerializedSize = KeyIdSpec.sizeOf(keyId);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)keyIdSerializedSize);
            protoOutputSize += keyIdSerializedSize;
        }
        if ((exitCode = protoInputObject.exitCode()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)7, (int)2);
            int exitCodeSerializedSize = ExitCodeSpec.sizeOf(exitCode);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)exitCodeSerializedSize);
            protoOutputSize += exitCodeSerializedSize;
        }
        if ((deviceIndex = protoInputObject.deviceIndex()) != null) {
            protoOutputSize += ProtobufOutputStream.getFieldSize((int)8, (int)0);
            protoOutputSize += ProtobufOutputStream.getVarIntSize((long)deviceIndex.intValue());
        }
        return protoOutputSize;
    }
}

